---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：58-BatchedGitRefUpdates::CleanupSchedulerWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **Cron実行頻度の詳細**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/batched_git_ref_updates/cleanup_scheduler_worker.rb`
- E-02: `app/services/batched_git_ref_updates/cleanup_scheduler_service.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Git参照更新のクリーンアップをスケジュール | E-01 L14-17 | ○ |
| C-02 | CleanupSchedulerService.executeを呼び出し | E-01 L15 | ○ |
| C-03 | log_extra_metadata_on_doneでstats出力 | E-01 L17 | ○ |
| C-04 | CronjobQueueをinclude | E-01 L7 | ○ |
| C-05 | idempotent!指定あり | E-01 L9 | ○ |
| C-06 | data_consistency: :sticky | E-01 L10 | ○ |
| C-07 | feature_category: :gitaly | E-01 L12 | ○ |
| C-08 | MAX_PROJECTS = 10,000 | E-02 L7 | ○ |
| C-09 | BATCH_SIZE = 100 | E-02 L8 | ○ |
| C-10 | LOCK_TIMEOUT = 10分 | E-02 L9 | ○ |
| C-11 | in_lockで排他制御（retries: 0） | E-02 L14 | ○ |
| C-12 | Deletion.status_pending.distinct_each_batch | E-02 L15 | ○ |
| C-13 | ProjectCleanupWorker.bulk_perform_async_with_contexts | E-02 L16-19 | ○ |
| C-14 | コンテキストなしでキュー | E-02 L19 | ○ |
| C-15 | 10,000プロジェクトで終了 | E-02 L23 | ○ |
| C-16 | { total_projects: N }を返却 | E-02 L27 | ○ |
| C-17 | Cron実行頻度の具体的な間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17：Cron実行頻度はsidekiq-cron設定ファイルの確認が必要
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（明確）
- 1: 中リスク - 大量削除対象時のパフォーマンス
- 0: 低リスク - 排他制御（ExclusiveLease使用）

## 6) レビュアーチェックリスト（最小）
- [ ] batched_git_ref_updates_deletionsテーブルのデータ量を確認
- [ ] ProjectCleanupWorkerの処理内容を確認
- [ ] 10,000プロジェクト制限が十分か確認
