---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：59-PagesDomainVerificationCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **needs_verificationスコープの詳細**：PagesDomainモデルの確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/pages_domain_verification_cron_worker.rb`
- E-02: `app/workers/pages_domain_verification_worker.rb`
- E-03: `app/workers/all_queues.yml`
- E-04: `app/models/pages_domain.rb`（推定：needs_verificationスコープ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pagesカスタムドメインの検証をスケジュール | E-01 L13-20 | ○ |
| C-02 | Gitlab::Database.read_only?をチェック | E-01 L14 | ○ |
| C-03 | PagesDomain.needs_verification.with_logging_info | E-01 L16 | ○ |
| C-04 | find_eachで順次処理 | E-01 L16 | ○ |
| C-05 | with_contextでproject設定 | E-01 L17 | ○ |
| C-06 | PagesDomainVerificationWorker.perform_async | E-01 L18 | ○ |
| C-07 | CronjobQueueをinclude | E-01 L8 | ○ |
| C-08 | data_consistency: :always | E-01 L6 | ○ |
| C-09 | feature_category: :pages | E-01 L10 | ○ |
| C-10 | worker_resource_boundary: :cpu | E-01 L11 | ○ |
| C-11 | PagesDomainVerificationWorkerがVerifyPagesDomainService実行 | E-02 L20 | ○ |
| C-12 | sidekiq_options retry: 3（VerificationWorker） | E-02 L9 | ○ |
| C-13 | CronjobChildWorkerをinclude（VerificationWorker） | E-02 L5 | ○ |
| C-14 | needs_verificationスコープの詳細条件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14：needs_verificationスコープの詳細条件はPagesDomainモデルの確認が必要
  - 候補：app/models/pages_domain.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（シンプル）
- 1: 中リスク - 大量ドメイン環境でのパフォーマンス
- 0: 低リスク - DNS検証の信頼性（外部依存）

## 6) レビュアーチェックリスト（最小）
- [ ] needs_verificationスコープの条件を確認
- [ ] 検証失敗時のドメイン無効化ロジックを確認
- [ ] DNS検証のタイムアウト設定を確認
