---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Ci_StuckBuilds_DropCancelingWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/stuck_builds/drop_canceling_worker.rb`
- E-02: `app/services/ci/stuck_builds/drop_canceling_service.rb`
- E-03: `app/services/ci/stuck_builds/drop_helpers.rb`
- E-04: `app/workers/stuck_ci_jobs_worker.rb`
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | idempotent!が設定 | E-01 (idempotent!) | ○ |
| C-02 | ExclusiveLeaseGuardをinclude | E-01 (include ExclusiveLeaseGuard) | ○ |
| C-03 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-04 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-05 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-06 | lease_timeoutは30分 | E-01 (lease_timeout: 30.minutes) | ○ |
| C-07 | DropCancelingServiceを実行 | E-01 (Ci::StuckBuilds::DropCancelingService.new.execute) | ○ |
| C-08 | TIMEOUTは1時間 | E-02 (TIMEOUT = 1.hour) | ○ |
| C-09 | cancelingスコープを使用 | E-02 (Ci::Build.canceling) | ○ |
| C-10 | created_at_beforeで1時間前を指定 | E-02 (created_at_before(TIMEOUT.ago)) | ○ |
| C-11 | updated_at_beforeで1時間前を指定 | E-02 (updated_at_before(TIMEOUT.ago)) | ○ |
| C-12 | orderでcreated_at ASC, project_id ASC | E-02 (order(created_at: :asc, project_id: :asc)) | ○ |
| C-13 | failure_reasonはstuck_or_timeout_failure | E-02 (failure_reason: :stuck_or_timeout_failure) | ○ |
| C-14 | BATCH_SIZEは100件 | E-03 (BATCH_SIZE = 100) | ○ |
| C-15 | OptimisticLockingで3回リトライ | E-03 (retry_lock build, 3) | ○ |
| C-16 | エラー時はdoom!で代替処理 | E-03 (build.doom!) | ○ |
| C-17 | StuckCiJobsWorkerから呼び出し | E-04 (Ci::StuckBuilds::DropCancelingWorker) | ○ |
| C-18 | カテゴリはCI/CD | E-05 (バッチ一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 1時間の停滞判定閾値が業務要件と一致しているか確認
- [ ] created_atとupdated_atの両方をチェックする理由を確認
- [ ] キャンセル中ジョブの正常なライフサイクルを確認
