---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：60-PagesDomainSslRenewalCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Cron実行頻度の詳細**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/pages_domain_ssl_renewal_worker.rb`
- E-02: `app/services/pages/domains/obtain_lets_encrypt_certificate_service.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PagesカスタムドメインのSSL証明書自動更新を実行 | E-01 L13-18 | ○ |
| C-02 | domain_idをパラメータとして受け取る | E-01 L13 | ○ |
| C-03 | PagesDomain.find_by_idでドメイン取得 | E-01 L14 | ○ |
| C-04 | domain.enabled?を確認 | E-01 L15 | ○ |
| C-05 | Gitlab::LetsEncrypt.enabled?を確認 | E-01 L16 | ○ |
| C-06 | ObtainLetsEncryptCertificateService.execute | E-01 L18 | ○ |
| C-07 | CronjobChildWorkerをinclude | E-01 L5 | ○ |
| C-08 | sidekiq_options retry: 3 | E-01 L9 | ○ |
| C-09 | data_consistency: :always | E-01 L7 | ○ |
| C-10 | feature_category: :pages | E-01 L11 | ○ |
| C-11 | CHALLENGE_PROCESSING_DELAY = 1分 | E-02 L8 | ○ |
| C-12 | CERTIFICATE_PROCESSING_DELAY = 1分 | E-02 L12 | ○ |
| C-13 | 期限切れACMEオーダーを削除 | E-02 L21 | ○ |
| C-14 | CreateAcmeOrderServiceで新規作成 | E-02 L25 | ○ |
| C-15 | 1分後に再キュー | E-02 L31, L42 | ○ |
| C-16 | ステータスready時に証明書リクエスト | E-02 L41 | ○ |
| C-17 | ステータスvalid時に証明書保存 | E-02 L44 | ○ |
| C-18 | ステータスinvalid時にエラー保存 | E-02 L46-47 | ○ |
| C-19 | NotificationService.pages_domain_auto_ssl_failedで通知 | E-02 L69 | ○ |
| C-20 | Cron実行頻度の具体的な間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20：Cron実行頻度はsidekiq-cron設定ファイルまたはconfig/initializers/1_settings.rbの確認が必要
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（明確な状態遷移）
- 1: 中リスク - Let's Encrypt API依存（外部サービス）
- 1: 中リスク - 証明書更新失敗時のサービス影響

## 6) レビュアーチェックリスト（最小）
- [ ] Let's Encrypt機能の有効化設定を確認
- [ ] 証明書更新失敗時の通知先を確認
- [ ] ACMEチャレンジの検証方法（DNS/HTTP）を確認
- [ ] 証明書有効期限の監視設定を確認
