---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：61-PagesDomainRemovalCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な件数の根拠なし
  2. **PagesDomainVerificationCronWorkerとの関連**：関連性の詳細確認が必要
  3. **処理時間の閾値**：監視設定の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/pages_domain_removal_cron_worker.rb`
- E-02: `app/models/pages_domain.rb`
- E-03: `config/initializers/1_settings.rb` (L642-644)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 削除予定時刻を超過したドメインを自動削除する | E-01 (L14: PagesDomain.for_removal) | ○ |
| C-02 | 日次実行（毎日0:47） | E-03 (cron: '47 0 * * *') | ○ |
| C-03 | for_removalスコープでremove_at < Time.currentを検索 | E-02 (L78: scope :for_removal) | ○ |
| C-04 | プロジェクトコンテキスト付きで処理 | E-01 (L15: with_context(project: domain.project)) | ○ |
| C-05 | destroy!で削除 | E-01 (L15: domain.destroy!) | ○ |
| C-06 | エラー時はErrorTrackingに記録 | E-01 (L17: Gitlab::ErrorTracking.track_exception) | ○ |
| C-07 | find_eachでバッチ処理 | E-01 (L14: find_each) | ○ |
| C-08 | worker_resource_boundary: :cpu | E-01 (L11) | ○ |
| C-09 | data_consistency: :always | E-01 (L6) | ○ |
| C-10 | with_logging_infoでproject関連を事前読み込み | E-01 (L14), E-02 (L80) | ○ |
| C-11 | IdempotentWorkerではない | E-01 (L3: rubocop:disable) | ○ |
| C-12 | 想定処理件数は数件〜数十件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がない
  - 候補：本番環境のメトリクス / 運用ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースに基づく主張は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 想定処理件数が運用実績と整合しているか確認
- [ ] PagesDomainVerificationCronWorkerとの連携動作を確認
- [ ] 削除時の関連テーブル（acme_orders）への影響を確認
