---
generated_at: 2026-01-22 14:02:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-Pages_DeactivateExpiredDeploymentsCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. 後続処理との連携確認（DeleteCronWorker）
  3. 運用時のパフォーマンス確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/pages/deactivate_expired_deployments_cron_worker.rb`
- E-02: `app/models/pages_deployment.rb`
- E-03: `config/initializers/1_settings.rb` (L814-816)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 期限切れのアクティブデプロイメントを非アクティブ化 | E-01 (L17), E-02 (L31-32) | ○ |
| C-02 | 10分間隔で定期実行 | E-03 (cron: '*/10 * * * *') | ○ |
| C-03 | MAX_NUM_DELETIONS = 10000 | E-01 (L13) | ○ |
| C-04 | BATCH_SIZE = 1000 | E-01 (L14) | ○ |
| C-05 | PagesDeployment.active.expired scopeを使用 | E-01 (L17), E-02 (L31-32) | ○ |
| C-06 | Keysetページネーションを使用 | E-01 (L19: Gitlab::Pagination::Keyset::Iterator) | ○ |
| C-07 | 各デプロイメントに対してdeactivateを実行 | E-01 (L24: deployments.each(&:deactivate)) | ○ |
| C-08 | 処理件数をカウント | E-01 (L20-25) | ○ |
| C-09 | 10,000件到達で処理中断 | E-01 (L27: break if count >= MAX_NUM_DELETIONS) | ○ |
| C-10 | メタデータログ出力（件数と処理時間） | E-01 (L30-33) | ○ |
| C-11 | idempotent!が設定されている | E-01 (L8) | ○ |
| C-12 | data_consistency: :always | E-01 (L9) | ○ |
| C-13 | deleted_atを現在時刻に更新 | E-02 (L94-96: deactivate メソッド) | ○ |
| C-14 | active scopeはdeleted_at=nullを条件とする | E-02 (L31: scope :active) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Pages::DeactivatedDeploymentsDeleteCronWorkerとの連携動作を確認
- [ ] 大量データ処理時のパフォーマンスを確認
- [ ] expires_at設定のユースケースを確認
