---
generated_at: 2026-01-22 14:04:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-Pages_DeactivatedDeploymentsDeleteCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. オブジェクトストレージ削除の動作確認
  3. 前段処理との連携確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/pages/deactivated_deployments_delete_cron_worker.rb`
- E-02: `app/models/pages_deployment.rb`
- E-03: `config/initializers/1_settings.rb` (L789-791)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非アクティブ化されたデプロイメントを物理削除 | E-01 (L14-16) | ○ |
| C-02 | 10分間隔で定期実行 | E-03 (cron: '*/10 * * * *') | ○ |
| C-03 | PagesDeployment.deactivated scopeを使用 | E-01 (L14), E-02 (L33) | ○ |
| C-04 | deactivated scopeは deleted_at < 現在時刻を条件 | E-02 (L33: scope :deactivated) | ○ |
| C-05 | each_batchでバッチ処理 | E-01 (L14) | ○ |
| C-06 | destroy!で物理削除 | E-01 (L15) | ○ |
| C-07 | idempotent!が設定されている | E-01 (L8) | ○ |
| C-08 | data_consistency: :always | E-01 (L9) | ○ |
| C-09 | FileStoreMounterでオブジェクトストレージ連携 | E-02 (L9, L45) | ○ |
| C-10 | feature_category: :pages | E-01 (L11) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Pages::DeactivateExpiredDeploymentsCronWorkerとの連携動作を確認
- [ ] オブジェクトストレージファイルの削除が正常に動作することを確認
- [ ] 大量削除時のパフォーマンスを確認
