---
generated_at: 2026-01-22 14:06:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-ImportExportProjectCleanupWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. ストレージパス設定の確認
  3. 大量ファイル削除時のパフォーマンス確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/import_export_project_cleanup_worker.rb`
- E-02: `app/services/import_export_clean_up_service.rb`
- E-03: `config/initializers/1_settings.rb` (L588-590)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImportExportCleanUpServiceを実行 | E-01 (L17) | ○ |
| C-02 | 毎時0分に実行 | E-03 (cron: '0 * * * *') | ○ |
| C-03 | LAST_MODIFIED_TIME_IN_MINUTES = 1440（24時間） | E-02 (L4) | ○ |
| C-04 | DIR_DEPTH = 5 | E-02 (L5) | ○ |
| C-05 | オブジェクトストレージのexport_fileを削除 | E-02 (L41-51) | ○ |
| C-06 | ImportExportUpload.with_export_file.updated_before | E-02 (L42) | ○ |
| C-07 | remove_export_file! + save! | E-02 (L43-44) | ○ |
| C-08 | findコマンドで古いディレクトリを検索 | E-02 (L62-63) | ○ |
| C-09 | FileUtils.remove_entryで削除 | E-02 (L32) | ○ |
| C-10 | ensureでファイルシステムクリーンアップを保証 | E-02 (L22-27) | ○ |
| C-11 | Gitlab::ImportExport.storage_pathを使用 | E-02 (L11) | ○ |
| C-12 | Gitlab::Metrics.measureで計測 | E-02 (L15-17) | ○ |
| C-13 | Import::Framework::Loggerでログ出力 | E-02 (L66-67) | ○ |
| C-14 | feature_category: :importers | E-01 (L14) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::ImportExport.storage_pathの設定を確認
- [ ] オブジェクトストレージの設定を確認
- [ ] 大量ファイル削除時のパフォーマンスを確認
