---
generated_at: 2026-01-22 14:08:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-BulkImports_StaleImportWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. state_machineの状態遷移確認
  3. トランザクション動作の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/bulk_imports/stale_import_worker.rb`
- E-02: `app/models/bulk_import.rb`
- E-03: `app/models/bulk_imports/entity.rb`
- E-04: `config/initializers/1_settings.rb` (L621-623)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 24時間以上更新のないインポートをタイムアウト状態に移行 | E-01 (L17-21), E-02 (L23, L44-47) | ○ |
| C-02 | 4時間間隔で定期実行 | E-04 (cron: '0 */4 * * *') | ○ |
| C-03 | BulkImport.stale scopeを使用 | E-01 (L46), E-02 (L23) | ○ |
| C-04 | staleは24時間経過 + status: 0,1 | E-02 (L23: where('updated_at < ?', 24.hours.ago).where(status: [0, 1])) | ○ |
| C-05 | Keysetページネーションを使用 | E-01 (L17, L24) | ○ |
| C-06 | cleanup_staleイベントでtimeout状態へ | E-01 (L20, L31), E-02 (L44-47) | ○ |
| C-07 | BulkImports::Entity.stale scopeを使用 | E-01 (L50), E-03 (L63) | ○ |
| C-08 | エンティティと関連トラッカーをトランザクションで処理 | E-01 (L26-35) | ○ |
| C-09 | トラッカーのcleanup_staleも発火 | E-01 (L34) | ○ |
| C-10 | エラーログ出力（BulkImport stale） | E-01 (L19) | ○ |
| C-11 | エラーログ出力（Entity stale） | E-01 (L27-29) | ○ |
| C-12 | idempotent!が設定されている | E-01 (L10) | ○ |
| C-13 | data_consistency: :sticky | E-01 (L11) | ○ |
| C-14 | feature_category: :importers | E-01 (L13) | ○ |
| C-15 | Logger.buildでロガー取得 | E-01 (L41-43) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] state_machineの状態遷移が正しく動作することを確認
- [ ] トランザクションによるエンティティ/トラッカーの原子性を確認
- [ ] 停滞判定の24時間が適切かを業務要件と照合
