---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-StuckExportJobsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. Sidekiqステータス確認の動作確認
  3. 並列エクスポートの6時間猶予期間の妥当性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/stuck_export_jobs_worker.rb`
- E-02: `app/models/project_export_job.rb`
- E-03: `config/initializers/1_settings.rb` (L630-632)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | queued/started状態のジョブを検索 | E-01 (L58) | ○ |
| C-02 | 毎時30分に実行 | E-03 (cron: '30 * * * *') | ○ |
| C-03 | EXPORT_JOBS_EXPIRATION = 6.hours.to_i | E-01 (L18) | ○ |
| C-04 | JIDリストを抽出（pluck） | E-01 (L30) | ○ |
| C-05 | Gitlab::SidekiqStatus.completed_jidsで完了確認 | E-01 (L32) | ○ |
| C-06 | 完了JID取得後に再度ジョブを検索 | E-01 (L39) | ○ |
| C-07 | relation_exportsで並列エクスポートチェック | E-01 (L50) | ○ |
| C-08 | 6時間以内の並列エクスポートはスキップ | E-01 (L50: created_at > EXPORT_JOBS_EXPIRATION.seconds.ago) | ○ |
| C-09 | fail_opでfailed状態に遷移 | E-01 (L52), E-02 (L36-37) | ○ |
| C-10 | Gitlab::Metrics.add_eventでメトリクス出力 | E-01 (L23) | ○ |
| C-11 | Sidekiq.loggerでログ出力 | E-01 (L41-44) | ○ |
| C-12 | worker_resource_boundary: :cpu | E-01 (L16) | ○ |
| C-13 | data_consistency: :always | E-01 (L7) | ○ |
| C-14 | feature_category: :importers | E-01 (L15) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::SidekiqStatusの動作を確認
- [ ] 並列エクスポートの6時間猶予期間が適切か確認
- [ ] 状態遷移の競合が発生しないことを確認
