---
generated_at: 2026-01-22 14:14:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-Gitlab_Import_ImportFileCleanupWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. RemoveImportFileWorkerとの連携確認
  3. 72時間の経過時間の妥当性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/gitlab/import/import_file_cleanup_worker.rb`
- E-02: `app/services/import/import_file_cleanup_service.rb`
- E-03: `config/initializers/1_settings.rb` (L591-593)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImportFileCleanupServiceを実行 | E-01 (L14) | ○ |
| C-02 | 毎時30分に実行 | E-03 (cron: '30 * * * *') | ○ |
| C-03 | LAST_MODIFIED = 72.hours | E-02 (L5) | ○ |
| C-04 | BATCH_SIZE = 100 | E-02 (L6) | ○ |
| C-05 | with_import_file.updated_before(72時間前)で検索 | E-02 (L9-11) | ○ |
| C-06 | each_batch(of: BATCH_SIZE)でバッチ処理 | E-02 (L12) | ○ |
| C-07 | RemoveImportFileWorker.perform_asyncでスケジュール | E-02 (L14) | ○ |
| C-08 | idempotent!が設定されている | E-01 (L9) | ○ |
| C-09 | data_consistency: :sticky | E-01 (L11) | ○ |
| C-10 | feature_category: :importers | E-01 (L10) | ○ |
| C-11 | インデックスに応じた遅延設定はない | E-02 (L14: perform_async) | ○ |
| C-12 | 各uploadのidを引数として渡す | E-02 (L14) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] RemoveImportFileWorkerの動作を確認
- [ ] 72時間の経過時間が適切か確認
- [ ] 大量削除時のSidekiqキュー負荷を確認
