---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Ci_TimedOutBuilds_DropTimedOutWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/timed_out_builds/drop_running_worker.rb`
- E-02: `app/services/ci/timed_out_builds/drop_running_service.rb`
- E-03: `app/services/ci/stuck_builds/drop_helpers.rb`
- E-04: `config/initializers/1_settings.rb`
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | idempotent!が設定 | E-01 (idempotent!) | ○ |
| C-02 | data_consistencyはsticky | E-01 (data_consistency :sticky) | ○ |
| C-03 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-04 | deduplicate :until_executed, ttl: 30.minutes | E-01 (deduplicate設定) | ○ |
| C-05 | queue_namespace :timed_out_builds | E-01 (queue_namespace) | ○ |
| C-06 | DropRunningServiceを実行 | E-01 (DropRunningService.new.execute) | ○ |
| C-07 | timed_out_buildsスコープを使用 | E-02 (Ci::Build.timed_out_builds) | ○ |
| C-08 | in_partitionでパーティション指定 | E-02 (in_partition(partition.id)) | ○ |
| C-09 | failure_reasonはjob_execution_timeout | E-02 (failure_reason: :job_execution_timeout) | ○ |
| C-10 | Ci::Partition.find_eachでループ | E-02 (Ci::Partition.find_each) | ○ |
| C-11 | StuckBuilds::DropHelpersをinclude | E-02 (include StuckBuilds::DropHelpers) | ○ |
| C-12 | BATCH_SIZEは100件 | E-03 (BATCH_SIZE = 100) | ○ |
| C-13 | OptimisticLockingで3回リトライ | E-03 (retry_lock build, 3) | ○ |
| C-14 | エラー時はdoom!で代替処理 | E-03 (build.doom!) | ○ |
| C-15 | cronは`*/10 * * * *` | E-04 (cron設定) | ○ |
| C-16 | カテゴリはCI/CD | E-05 (バッチ一覧.csv) | ○ |
| C-17 | ログ出力"Cleaning timed-out builds" | E-02 (Gitlab::AppLogger.info) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] timed_out_buildsスコープの判定条件を確認
- [ ] data_consistency :stickyの影響を確認（レプリカ読み取り許可）
- [ ] DropRunningWorker（StuckBuilds）との役割分担を確認
