---
generated_at: 2026-01-22 14:18:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-Import_PlaceholderUserCleanupWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. DeletePlaceholderUserWorkerとの連携確認
  3. eligible_for_deletionのUNIONクエリ確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/import/placeholder_user_cleanup_worker.rb`
- E-02: `app/models/import/placeholder_user_detail.rb`
- E-03: `config/initializers/1_settings.rb` (L834-836)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 日次実行（毎日0:00 UTC） | E-03 (cron: '0 0 * * *') | ○ |
| C-02 | MAX_ATTEMPTS = 15 | E-01 (L12) | ○ |
| C-03 | DELETION_RETRY_PERIOD = 2.days | E-02 (L7) | ○ |
| C-04 | eligible_for_deletion scopeを使用 | E-01 (L15), E-02 (L16-26) | ○ |
| C-05 | namespace_id IS NULLを条件とする | E-02 (L17) | ○ |
| C-06 | deletion_attempts < MAX_ATTEMPTSを条件とする | E-02 (L17) | ○ |
| C-07 | last_deletion_attempt_at IS NULLまたは2日以上前 | E-02 (L19-20) | ○ |
| C-08 | UNIONクエリを使用 | E-02 (L22-25) | ○ |
| C-09 | increment_deletion_attemptで試行回数更新 | E-01 (L16), E-02 (L28-30) | ○ |
| C-10 | 最大試行回数到達時に警告ログ出力 | E-01 (L17, L29-34) | ○ |
| C-11 | DeletePlaceholderUserWorker.perform_inでスケジュール | E-01 (L21) | ○ |
| C-12 | index * 1秒の遅延を設定 | E-01 (L19, L21) | ○ |
| C-13 | idempotent!が設定されている | E-01 (L8) | ○ |
| C-14 | deduplicate :until_executed | E-01 (L11) | ○ |
| C-15 | data_consistency: :sticky | E-01 (L9) | ○ |
| C-16 | Import::Framework::Loggerでログ出力 | E-01 (L30) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] DeletePlaceholderUserWorkerの動作を確認
- [ ] 15回の最大試行回数が適切か確認
- [ ] 2日間のリトライ間隔が適切か確認
