---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：71-ScheduleMergeRequestCleanupRefsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **アラート閾値**：具体的な監視閾値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/schedule_merge_request_cleanup_refs_worker.rb`
- E-02: `app/workers/merge_request_cleanup_refs_worker.rb`
- E-03: `app/models/merge_request/cleanup_schedule.rb`
- E-04: `config/initializers/1_settings.rb` (cron設定)
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎分実行される | E-04 (cron: `* * * * *`) | ○ |
| C-02 | データベースが読み取り専用モードの場合スキップ | E-01 (line 14: `return if Gitlab::Database.read_only?`) | ○ |
| C-03 | stuck_retry!で停滞タスクをリトライ | E-01 (line 16), E-03 (line 70-72) | ○ |
| C-04 | 停滞タスクは6時間以上running状態のもの | E-03 (line 55-57: scope :stuck) | ○ |
| C-05 | リトライは最大5件まで | E-03 (line 12: STUCK_RETRY_LIMIT = 5) | ○ |
| C-06 | MergeRequestCleanupRefsWorkerを呼び出す | E-01 (line 17) | ○ |
| C-07 | 最大4つの同時実行ジョブ | E-02 (line 18: MAX_RUNNING_JOBS = 4) | ○ |
| C-08 | idempotent!として宣言 | E-01 (line 11) | ○ |
| C-09 | feature_categoryはcode_review_workflow | E-01 (line 10) | ○ |
| C-10 | data_consistencyはalways | E-01 (line 6) | ○ |
| C-11 | CronjobQueueをinclude | E-01 (line 8) | ○ |
| C-12 | CleanupScheduleのステータスは4種類 | E-03 (line 4-9: STATUSES) | ○ |
| C-13 | リトライ時にfailed_countをインクリメント | E-03 (line 44-46) | ○ |
| C-14 | start_nextでFOR UPDATE SKIP LOCKEDを使用 | E-03 (line 61) | ○ |
| C-15 | 監視閾値は継続的な失敗時にアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定の詳細
  - 候補：`config/application_settings.yml` / 運用ドキュメント / 監視システム設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析により主要な処理ロジックは確認済み
- 1: 中リスク - 監視設定の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 毎分実行が適切か（負荷観点）
- [ ] 停滞タスクのリトライ最大5件が適切か
- [ ] 同時実行数4が環境に適切か
