---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：72-StuckMergeJobsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的な閾値設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/stuck_merge_jobs_worker.rb`
- E-02: `app/models/merge_request.rb` (merge_ongoing?メソッドのコメント)
- E-03: `app/services/merge_requests/unstick_locked_merge_requests_service.rb`
- E-04: `config/initializers/1_settings.rb` (cron設定: line 636-638)
- E-05: `lib/gitlab/merge_requests/locked_set.rb`
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 15分ごとに実行される | E-04 (cron: `*/15 * * * *`) | ○ |
| C-02 | バッチサイズ100件で処理 | E-01 (line 21: `batch_size: 100`) | ○ |
| C-03 | locked状態でmerge_jidがあるMRを対象 | E-01 (line 72-74: stuck_merge_requests) | ○ |
| C-04 | Sidekiqステータスで完了を確認 | E-01 (line 29: `Gitlab::SidekiqStatus.completed_jids`) | ○ |
| C-05 | merge_commit_shaありならmergedに更新 | E-01 (line 47) | ○ |
| C-06 | merge_commit_shaなしならunlock_mr | E-01 (line 49-58) | ○ |
| C-07 | ログにJIDを記録 | E-01 (line 65: logger.info) | ○ |
| C-08 | エラー時はログに記録 | E-01 (line 60-62, 66-67) | ○ |
| C-09 | use_locked_set?で処理分岐 | E-01 (line 18) | ○ |
| C-10 | UnstickLockedMergeRequestsServiceを呼び出す | E-01 (line 19), E-03 | ○ |
| C-11 | idempotentでない | E-01 (line 3: rubocop:disable) | ○ |
| C-12 | feature_categoryはcode_review_workflow | E-01 (line 10) | ○ |
| C-13 | data_consistencyはalways | E-01 (line 6) | ○ |
| C-14 | CronjobQueueをinclude | E-01 (line 8) | ○ |
| C-15 | 状態遷移はステートマシンコールバックに依存 | E-01 (line 51-52: コメント) | ○ |
| C-16 | 監視閾値は急増時にアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視・アラートの具体的な閾値設定
  - 候補：運用ドキュメント / 監視システム設定 / Prometheus設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理ロジックを完全に追跡可能
- 1: 中リスク - フィーチャーフラグによる分岐があり、両方のパスを確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] use_locked_set?フィーチャーフラグの現在の状態を確認
- [ ] 15分間隔が環境に適切か
- [ ] バッチサイズ100が適切か（大規模インスタンス向け）
- [ ] unlock_mr失敗時のエラーハンドリングが適切か
