---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：73-MergeRequests_ProcessScheduledMergeWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/merge_requests/process_scheduled_merge_worker.rb`
- E-02: `app/models/merge_requests/merge_schedule.rb`
- E-03: `config/initializers/1_settings.rb` (line 820-822)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎分実行される | E-03 (cron: `*/1 * * * *`) | ○ |
| C-02 | 排他ロックを使用 | E-01 (line 10, 21: ExclusiveLeaseHelpers, in_lock) | ○ |
| C-03 | ロックTTLは5分 | E-01 (line 13: LOCK_TTL = 5.minutes) | ○ |
| C-04 | ロックリトライは3回 | E-01 (line 12: LOCK_RETRY = 3) | ○ |
| C-05 | バッチサイズは500件 | E-01 (line 15: BATCH_SIZE = 500) | ○ |
| C-06 | バッチ間遅延は7秒 | E-01 (line 14: DELAY = 7.seconds) | ○ |
| C-07 | Keyset Paginationを使用 | E-01 (line 23-41: Keyset::Order, Keyset::Iterator) | ○ |
| C-08 | merge_afterでソート | E-01 (line 25-28) | ○ |
| C-09 | merge_request_idでソート | E-01 (line 29-33) | ○ |
| C-10 | merge_after <= NOW()でフィルタ | E-01 (line 37) | ○ |
| C-11 | auto_merge有効MRをフィルタ | E-01 (line 45-46: with_auto_merge_enabled) | ○ |
| C-12 | AutoMergeProcessWorkerをエンキュー | E-01 (line 70-75) | ○ |
| C-13 | bulk_perform_in_with_contextsを使用 | E-01 (line 70) | ○ |
| C-14 | idempotentでない | E-01 (line 4: rubocop:disable) | ○ |
| C-15 | feature_categoryはcode_review_workflow | E-01 (line 17) | ○ |
| C-16 | worker_resource_boundaryはcpu | E-01 (line 18) | ○ |
| C-17 | 監視閾値は5分超過でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析から処理フローを完全に追跡可能
- 0: 低リスク - 排他制御が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 毎分実行が適切か（負荷観点）
- [ ] ロックTTL 5分がバッチ処理時間に対して適切か
- [ ] バッチサイズ500と遅延7秒のバランスが適切か
- [ ] 大量のスケジュールがある場合のパフォーマンス影響を確認
