---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：74-Issues_RescheduleStuckIssueRebalancesWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/issues/reschedule_stuck_issue_rebalances_worker.rb`
- E-02: `lib/gitlab/issues/rebalancing/state.rb`
- E-03: `config/initializers/1_settings.rb` (line 747-749)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 15分ごとに実行される | E-03 (cron: `*/15 * * * *`) | ○ |
| C-02 | Redisから再バランス中コンテナ情報を取得 | E-01 (line 16), E-02 (line 140-156) | ○ |
| C-03 | 空の場合は処理をスキップ | E-01 (line 18) | ○ |
| C-04 | Namespace.id_inで対象取得 | E-01 (line 20) | ○ |
| C-05 | Project.id_inで対象取得 | E-01 (line 21) | ○ |
| C-06 | RebalancingWorkerをbulk_perform_async_with_contexts | E-01 (line 23-27, 29-33) | ○ |
| C-07 | ネームスペースにはnamespace.idを渡す | E-01 (line 24) | ○ |
| C-08 | プロジェクトにはproject.idを渡す | E-01 (line 30) | ○ |
| C-09 | idempotent!として宣言 | E-01 (line 10) | ○ |
| C-10 | feature_categoryはteam_planning | E-01 (line 12) | ○ |
| C-11 | data_consistencyはsticky | E-01 (line 8) | ○ |
| C-12 | urgencyはlow | E-01 (line 11) | ○ |
| C-13 | deduplicateが設定されている | E-01 (line 13) | ○ |
| C-14 | 同時実行制限は最大5件 | E-02 (line 12: MAX_NUMBER_OF_CONCURRENT_REBALANCES = 5) | ○ |
| C-15 | Redis有効期限は10日 | E-02 (line 11: REDIS_EXPIRY_TIME = 10.days) | ○ |
| C-16 | 監視閾値は長期間存在でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / 監視ダッシュボード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 0: 低リスク - Redis状態管理が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 15分間隔が再バランス処理の検出に適切か
- [ ] 同時実行制限5件が環境に適切か
- [ ] Redis有効期限10日が適切か
- [ ] 大規模インスタンスでの動作確認
