---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：75-Environments_AutoStopCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/environments/auto_stop_cron_worker.rb`
- E-02: `app/services/environments/auto_stop_service.rb`
- E-03: `app/models/environment.rb` (auto_stoppable scope)
- E-04: `config/initializers/1_settings.rb` (line 561-563)
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎時24分に実行される | E-04 (cron: `24 * * * *`) | ○ |
| C-02 | AutoStopServiceを呼び出す | E-01 (line 15) | ○ |
| C-03 | 排他ロックを使用 | E-02 (line 5, 21: ExclusiveLeaseHelpers, in_lock) | ○ |
| C-04 | ロックキーはenvironments:auto_stop:lock | E-02 (line 11) | ○ |
| C-05 | ロックTTLは50分 | E-02 (line 12: LOCK_TIMEOUT = 50.minutes) | ○ |
| C-06 | ループタイムアウトは45分 | E-02 (line 9: LOOP_TIMEOUT = 45.minutes) | ○ |
| C-07 | 最大ループ回数は1000回 | E-02 (line 10: LOOP_LIMIT = 1000) | ○ |
| C-08 | バッチサイズは100件 | E-02 (line 8: BATCH_SIZE = 100) | ○ |
| C-09 | auto_stoppableスコープで対象取得 | E-02 (line 31), E-03 (line 126) | ○ |
| C-10 | available状態かつauto_stop_at < NOW | E-03 (line 126: scope :auto_stoppable) | ○ |
| C-11 | AutoStopWorkerをバルクエンキュー | E-02 (line 35-38) | ○ |
| C-12 | 環境IDとプロジェクトコンテキストを渡す | E-02 (line 36-38) | ○ |
| C-13 | idempotentでない | E-01 (line 4: rubocop:disable) | ○ |
| C-14 | feature_categoryはcontinuous_delivery | E-01 (line 11) | ○ |
| C-15 | data_consistencyはalways | E-01 (line 7) | ○ |
| C-16 | worker_resource_boundaryはcpu | E-01 (line 12) | ○ |
| C-17 | 監視閾値は50分超過でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / インフラ監視設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 0: 低リスク - 排他制御とループ制御が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 毎時24分の実行タイミングが適切か
- [ ] ロックTTL 50分とループタイムアウト45分のバランスが適切か
- [ ] バッチサイズ100が環境に適切か
- [ ] 大量の自動停止対象がある場合のパフォーマンス影響を確認
