---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：76-Environments_AutoDeleteCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/environments/auto_delete_cron_worker.rb`
- E-02: `app/models/environment.rb` (auto_deletable scope, line 127)
- E-03: `config/initializers/1_settings.rb` (line 564-566)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎時34分に実行される | E-03 (cron: `34 * * * *`) | ○ |
| C-02 | LoopHelpersをinclude | E-01 (line 6) | ○ |
| C-03 | ループタイムアウトは45分 | E-01 (line 14: LOOP_TIMEOUT = 45.minutes) | ○ |
| C-04 | 最大ループ回数は1000回 | E-01 (line 15: LOOP_LIMIT = 1000) | ○ |
| C-05 | バッチサイズは100件 | E-01 (line 16: BATCH_SIZE = 100) | ○ |
| C-06 | auto_deletableスコープで対象取得 | E-01 (line 27), E-02 (line 127) | ○ |
| C-07 | stopped状態かつauto_delete_at < NOW | E-02 (line 127: scope :auto_deletable) | ○ |
| C-08 | 各環境をdestroyで削除 | E-01 (line 31) | ○ |
| C-09 | idempotent!として宣言 | E-01 (line 12) | ○ |
| C-10 | feature_categoryはcontinuous_delivery | E-01 (line 10) | ○ |
| C-11 | data_consistencyはalways | E-01 (line 9) | ○ |
| C-12 | deduplicateが設定されている | E-01 (line 11) | ○ |
| C-13 | loop_untilでループ制御 | E-01 (line 19-21) | ○ |
| C-14 | 対象がないとfalseを返す | E-01 (line 29) | ○ |
| C-15 | 監視閾値は45分超過でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / インフラ監視設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 1: 中リスク - destroy処理のカスケード影響を確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] 毎時34分の実行タイミングが適切か
- [ ] destroy時の関連レコード削除が適切に動作するか
- [ ] バッチサイズ100が環境に適切か
- [ ] 大量の削除対象がある場合のDB負荷を確認
