---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：77-PruneOldEventsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/prune_old_events_worker.rb`
- E-02: `config/initializers/1_settings.rb` (line 609-611)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6時間ごとに実行される | E-02 (cron: `0 */6 * * *`) | ○ |
| C-02 | DELETE_LIMITは10000件 | E-01 (line 15) | ○ |
| C-03 | CUTOFF_DATEは3年1日 | E-01 (line 17: 3.years + 1.day) | ○ |
| C-04 | フィーチャーフラグで制御 | E-01 (line 19-21, 24) | ○ |
| C-05 | フラグ名はops_prune_old_events | E-01 (line 20) | ○ |
| C-06 | フラグタイプは:ops | E-01 (line 20) | ○ |
| C-07 | フラグ無効時はログ出力 | E-01 (line 29) | ○ |
| C-08 | Event.unscopedを使用 | E-01 (line 27) | ○ |
| C-09 | created_beforeスコープを使用 | E-01 (line 27) | ○ |
| C-10 | delete_with_limitで削除 | E-01 (line 27) | ○ |
| C-11 | idempotentでない | E-01 (line 3: rubocop:disable) | ○ |
| C-12 | feature_categoryはuser_profile | E-01 (line 13) | ○ |
| C-13 | data_consistencyはsticky | E-01 (line 5) | ○ |
| C-14 | 監視閾値は異常な増加でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / データベース監視設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 0: 低リスク - フィーチャーフラグで安全に制御されている

## 6) レビュアーチェックリスト（最小）
- [ ] フィーチャーフラグの現在の状態を確認
- [ ] 3年1日の保持期間が要件を満たすか
- [ ] 6時間ごと・1万件削除が環境に適切か
- [ ] 大量のイベントがある場合の削除ペースを確認
