---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：79-GitlabPerformanceBarStatsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/gitlab_performance_bar_stats_worker.rb`
- E-02: `lib/gitlab/performance_bar/stats.rb`
- E-03: `config/initializers/1_settings.rb` (line 801-803)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2分ごとに実行される | E-03 (cron: `*/2 * * * *`) | ○ |
| C-02 | STATS_KEYはperformance_bar_stats:pending_request_ids | E-01 (line 12) | ○ |
| C-03 | STATS_KEY_EXPIREは30分 | E-01 (line 13) | ○ |
| C-04 | Gitlab::Redis::Cacheを使用 | E-01 (line 32-33) | ○ |
| C-05 | smembersでリクエストID取得 | E-01 (line 37) | ○ |
| C-06 | 取得後にdelでキー削除 | E-01 (line 38) | ○ |
| C-07 | Stats.processを各IDに実行 | E-01 (line 25), E-02 (line 21-30) | ○ |
| C-08 | peek:requests:#{id}からデータ取得 | E-02 (line 36) | ○ |
| C-09 | active-record, gitaly, redisを解析 | E-02 (line 25-27) | ○ |
| C-10 | ログにmethod_path等を出力 | E-02 (line 47-55) | ○ |
| C-11 | エラー時はlogger.errorに出力 | E-02 (line 29) | ○ |
| C-12 | idempotent!として宣言 | E-01 (line 16) | ○ |
| C-13 | feature_categoryはobservability | E-01 (line 15) | ○ |
| C-14 | data_consistencyはalways | E-01 (line 7) | ○ |
| C-15 | worker_resource_boundaryはcpu | E-01 (line 8) | ○ |
| C-16 | sidekiq_options retry: 3 | E-01 (line 10) | ○ |
| C-17 | 監視閾値は2分超過でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / パフォーマンス監視設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 0: 低リスク - エラーハンドリングが適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 2分間隔がパフォーマンスバー使用頻度に適切か
- [ ] STATS_KEY_EXPIRE 30分が適切か
- [ ] 除外対象のバックトレースパスが最新か
- [ ] 大量のリクエストがある場合の処理時間を確認
