---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-Ci_PartitioningWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パーティション状態遷移の詳細**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/partitioning_worker.rb`
- E-02: `app/services/ci/partitions/setup_default_service.rb`
- E-03: `app/services/ci/partitions/create_service.rb`
- E-04: `app/services/ci/partitions/sync_service.rb`
- E-05: `config/initializers/1_settings.rb`
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | idempotent!が設定 | E-01 (idempotent!) | ○ |
| C-02 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-03 | feature_categoryはci_scaling | E-01 (feature_category :ci_scaling) | ○ |
| C-04 | deduplicate :until_executed | E-01 (deduplicate設定) | ○ |
| C-05 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-06 | SetupDefaultServiceを実行 | E-01 (Ci::Partitions::SetupDefaultService.new.execute) | ○ |
| C-07 | Ci::Partition.currentで現在パーティション取得 | E-01 (Ci::Partition.current) | ○ |
| C-08 | CreateServiceを実行 | E-01 (Ci::Partitions::CreateService.new) | ○ |
| C-09 | SyncServiceを実行 | E-01 (Ci::Partitions::SyncService.new) | ○ |
| C-10 | HEADROOM_PARTITIONS = 2 | E-03 (HEADROOM_PARTITIONS = 2) | ○ |
| C-11 | above_threshold?で閾値判定 | E-03 (above_threshold?) | ○ |
| C-12 | create_next!で新規作成 | E-03 (Ci::Partition.create_next!) | ○ |
| C-13 | sync_available_partitions_statuses!で状態同期 | E-04 (sync_available_partitions_statuses!) | ○ |
| C-14 | switch_writes!で書き込み先切り替え | E-04 (next_ci_partition.switch_writes!) | ○ |
| C-15 | cronは`0 2 * * *` | E-05 (cron設定) | ○ |
| C-16 | カテゴリはデータベース管理 | E-06 (バッチ一覧.csv) | ○ |
| C-17 | DEFAULT_PARTITION_VALUESを使用 | E-02 (DEFAULT_PARTITION_VALUES) | ○ |
| C-18 | パーティション状態遷移: preparing→ready→current→active | **コードから推測** | △ |

## 4) 不足情報（Unknown / Missing）
- パーティション状態遷移の完全なライフサイクル定義
  - 候補：Ci::Partitionモデルの定義 / ステータスenum定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] ci_partitionsテーブルの構造を確認
- [ ] パーティション閾値（above_threshold?）の具体的な値を確認
- [ ] パーティション状態遷移の完全なフローを確認
