---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：80-GitlabServicePingWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **監視閾値詳細**：具体的なアラート設定の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/gitlab_service_ping_worker.rb`
- E-02: `config/initializers/1_settings.rb` (line 633-635)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cronは動的にスケジュールされる | E-02 (cron: nil - dynamically loaded) | ○ |
| C-02 | usage_ping_generation_enabled?を確認 | E-01 (line 21) | ○ |
| C-03 | LEASE_KEY定義 | E-01 (line 4) | ○ |
| C-04 | NON_SQL_LEASE_KEY定義 | E-01 (line 5) | ○ |
| C-05 | QUERIES_LEASE_KEY定義 | E-01 (line 6) | ○ |
| C-06 | LEASE_TIMEOUTは86400秒 | E-01 (line 7) | ○ |
| C-07 | 非SQLデータをNonSqlServicePingにupsert | E-01 (line 88) | ○ |
| C-08 | SQLクエリデータをQueriesServicePingにupsert | E-01 (line 104) | ○ |
| C-09 | RawUsageDataにペイロードをupsert | E-01 (line 58) | ○ |
| C-10 | GitLab.comかつCronトリガーでスキップ | E-01 (line 41) | ○ |
| C-11 | triggered_from_cronデフォルトはtrue | E-01 (line 37) | ○ |
| C-12 | SubmitServiceで送信 | E-01 (line 44) | ○ |
| C-13 | retry: 3, dead: false | E-01 (line 17) | ○ |
| C-14 | リトライ間隔は(count + 1) * 8時間 | E-01 (line 18) | ○ |
| C-15 | ランダムスリープ0〜60秒 | E-01 (line 71) | ○ |
| C-16 | Organization.firstでorganization_id取得 | E-01 (line 23) | ○ |
| C-17 | feature_categoryはservice_ping | E-01 (line 15) | ○ |
| C-18 | data_consistencyはsticky | E-01 (line 11) | ○ |
| C-19 | worker_resource_boundaryはcpu | E-01 (line 16) | ○ |
| C-20 | 監視閾値は複数日連続失敗でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な監視・アラート設定
  - 候補：Prometheus設定 / 運用マニュアル / Service Ping監視設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから処理フローを完全に追跡可能
- 1: 中リスク - 外部API送信のため、ネットワーク問題を考慮必要

## 6) レビュアーチェックリスト（最小）
- [ ] usage_ping_generation_enabled設定が適切か
- [ ] GitLab.comでの動作が意図通りか
- [ ] リトライ間隔8時間が適切か
- [ ] ペイロードサイズとメモリ使用量の関係を確認
- [ ] 外部送信のセキュリティ・プライバシー要件を確認
