---
generated_at: 2026-01-22 14:34:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：83-Namespaces_PruneAggregationSchedulesWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **schedule_root_storage_statisticsの内部動作**：モデルの実装が未確認
  2. **監視・アラートの閾値設定**：運用設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/namespaces/prune_aggregation_schedules_worker.rb`（ワーカー実装）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | feature_categoryはsource_code_management | E-01 L11 | ○ |
| C-02 | idempotent!は設定されていない | E-01 L4 rubocop:disable | ○ |
| C-03 | data_consistencyは:always | E-01 L7 | ○ |
| C-04 | CronjobQueueを使用 | E-01 L9 | ○ |
| C-05 | worker_resource_boundaryは:cpu | E-01 L12 | ○ |
| C-06 | 毎日1:05に実行 | E-01 L15 コメント | ○ |
| C-07 | Namespace::AggregationSchedule.allで取得 | E-01 L25 | ○ |
| C-08 | find_eachでイテレーション | E-01 L17 | ○ |
| C-09 | schedule_root_storage_statisticsを呼び出し | E-01 L18 | ○ |
| C-10 | バッチ名はNamespaces::PruneAggregationSchedulesWorker | E-02 No.83 | ○ |
| C-11 | カテゴリはNamespace管理 | E-02 No.83 | ○ |
| C-12 | 保留スケジュールをプルーニング | E-01 L14 コメント | ○ |
| C-13 | schedule_root_storage_statisticsの内部動作詳細 | **根拠なし** | △ |
| C-14 | 監視・アラートの閾値設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Namespace::AggregationScheduleモデルの実装が未確認
  - 候補：app/models/namespace/aggregation_schedule.rb
- schedule_root_storage_statisticsメソッドの詳細実装が未確認
- 監視・アラート設定は運用環境に依存するため、本番設定ファイルが必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - idempotentではないため、重複実行時の影響を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] Namespace::AggregationScheduleモデルの実装を確認
- [ ] schedule_root_storage_statisticsメソッドの動作を確認
- [ ] 大量レコード存在時のパフォーマンス影響を確認
- [ ] idempotentでない理由を確認
