---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：86-Packages_CleanupPackageRegistryWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **子ワーカーの詳細動作**：子ワーカー実装が未確認
  2. **監視・アラートの閾値設定**：運用設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/packages/cleanup_package_registry_worker.rb`（ワーカー実装）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | feature_categoryはpackage_registry | E-01 L11 | ○ |
| C-02 | idempotent!が設定されている | E-01 L9 | ○ |
| C-03 | data_consistencyは:sticky | E-01 L8 | ○ |
| C-04 | CronjobQueueを使用 | E-01 L6 | ○ |
| C-05 | PackageFile.pending_destruction存在チェック | E-01 L14 | ○ |
| C-06 | Policy.runnable存在チェック | E-01 L15 | ○ |
| C-07 | Npm::MetadataCache.pending_destruction存在チェック | E-01 L16 | ○ |
| C-08 | Helm::MetadataCache.pending_destruction存在チェック | E-01 L17 | ○ |
| C-09 | Nuget::Symbol.pending_destruction存在チェック | E-01 L18 | ○ |
| C-10 | CleanupPackageFileWorker.perform_with_capacity呼び出し | E-01 L26 | ○ |
| C-11 | ExecutePolicyWorker.perform_with_capacity呼び出し | E-01 L30 | ○ |
| C-12 | Npm::CleanupStaleMetadataCacheWorker.perform_with_capacity呼び出し | E-01 L34 | ○ |
| C-13 | Helm::CleanupStaleMetadataCacheWorker.perform_with_capacity呼び出し | E-01 L38 | ○ |
| C-14 | Nuget::CleanupStaleSymbolsWorker.perform_with_capacity呼び出し | E-01 L42 | ○ |
| C-15 | log_countsでカウント情報出力 | E-01 L45-55 | ○ |
| C-16 | 各ステータスのカウントをログ出力 | E-01 L46-52 | ○ |
| C-17 | 子ワーカーの詳細動作 | **根拠なし** | △ |
| C-18 | 監視・アラートの閾値設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 子ワーカーの実装が未確認
  - 候補：CleanupPackageFileWorker, ExecutePolicyWorker, CleanupStaleMetadataCacheWorker, CleanupStaleSymbolsWorker
- perform_with_capacityの動作詳細が未確認
- 監視・アラート設定は運用環境に依存するため、本番設定ファイルが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - オーケストレーターとして機能し、実際の削除は子ワーカーで行う

## 6) レビュアーチェックリスト（最小）
- [ ] 子ワーカーの実装を確認
- [ ] perform_with_capacityのキャパシティ設定を確認
- [ ] 各pending_destructionステータスの設定条件を確認
- [ ] error_package_files_countが増加する原因を確認
