---
generated_at: 2026-01-22 14:42:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：87-Packages_Cleanup_DeleteOrphanedDependenciesWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **orphanedスコープの定義**：モデル実装が未確認
  2. **監視・アラートの閾値設定**：運用設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/packages/cleanup/delete_orphaned_dependencies_worker.rb`（ワーカー実装）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | feature_categoryはpackage_registry | E-01 L10 | ○ |
| C-02 | idempotent!が設定されている | E-01 L12 | ○ |
| C-03 | data_consistencyは:sticky | E-01 L9 | ○ |
| C-04 | urgencyは:low | E-01 L11 | ○ |
| C-05 | CronjobQueueを使用 | E-01 L7 | ○ |
| C-06 | MAX_RUN_TIMEは2分 | E-01 L16 | ○ |
| C-07 | MAX_BATCHESは10 | E-01 L17 | ○ |
| C-08 | BATCH_SIZEは100 | E-01 L18 | ○ |
| C-09 | REDIS_EXPIRATION_TIMEは2時間 | E-01 L20 | ○ |
| C-10 | Redisキーは特定の文字列 | E-01 L19 | ○ |
| C-11 | monotonic_timeで時間計測 | E-01 L46 | ○ |
| C-12 | over_time?で時間超過チェック | E-01 L49-50 | ○ |
| C-13 | Packages::Dependency.id_inでバッチ取得 | E-01 L29 | ○ |
| C-14 | each_batchでバッチ処理 | E-01 L29 | ○ |
| C-15 | .orphaned.delete_allで削除 | E-01 L31 | ○ |
| C-16 | Redisでカーソル管理 | E-01 L53-68 | ○ |
| C-17 | log_extra_metadata_on_doneでログ出力 | E-01 L75-77 | ○ |
| C-18 | 10分間隔で実行 | E-01 L14-15 コメント | ○ |
| C-19 | orphanedスコープの定義詳細 | **根拠なし** | △ |
| C-20 | 監視・アラートの閾値設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Packages::Dependencyモデルのorphanedスコープ定義が未確認
  - 候補：app/models/packages/dependency.rb
- 10分間隔の実行はコメントによる記載のみで、実際のCron設定が未確認
- 監視・アラート設定は運用環境に依存するため、本番設定ファイルが必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - データ削除を行うため、orphanedスコープの定義を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] Packages::Dependencyモデルのorphanedスコープを確認
- [ ] 孤立判定のロジックが正しいか確認
- [ ] 10分間隔のCron設定を確認
- [ ] 大量の孤立レコードがある場合のパフォーマンスを確認
