---
generated_at: 2026-01-22 14:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：89-DependencyProxy_CleanupDependencyProxyWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **子ワーカーの詳細動作**：子ワーカー実装が未確認
  2. **監視・アラートの閾値設定**：運用設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/dependency_proxy/cleanup_dependency_proxy_worker.rb`（ワーカー実装）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | feature_categoryはvirtual_registry | E-01 L11 | ○ |
| C-02 | idempotent!が設定されている | E-01 L9 | ○ |
| C-03 | data_consistencyは:sticky | E-01 L8 | ○ |
| C-04 | CronjobQueueを使用 | E-01 L6 | ○ |
| C-05 | Blob.pending_destruction.any?でチェック | E-01 L14 | ○ |
| C-06 | Manifest.pending_destruction.any?でチェック | E-01 L15 | ○ |
| C-07 | CleanupBlobWorker.perform_with_capacity呼び出し | E-01 L21 | ○ |
| C-08 | CleanupManifestWorker.perform_with_capacity呼び出し | E-01 L25 | ○ |
| C-09 | prepend_modでEE拡張 | E-01 L30 | ○ |
| C-10 | バッチ名はDependencyProxy::CleanupDependencyProxyWorker | E-02 No.89 | ○ |
| C-11 | カテゴリは依存プロキシ | E-02 No.89 | ○ |
| C-12 | 説明は「依存プロキシのクリーンアップ」 | E-02 No.89 | ○ |
| C-13 | 子ワーカーの詳細動作 | **根拠なし** | △ |
| C-14 | 監視・アラートの閾値設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 子ワーカーの実装が未確認
  - 候補：CleanupBlobWorker, CleanupManifestWorker
- perform_with_capacityの動作詳細が未確認
- pending_destructionステータスの設定条件が未確認
- 監視・アラート設定は運用環境に依存するため、本番設定ファイルが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - オーケストレーターとして機能し、実際の削除は子ワーカーで行う

## 6) レビュアーチェックリスト（最小）
- [ ] CleanupBlobWorkerの実装を確認
- [ ] CleanupManifestWorkerの実装を確認
- [ ] perform_with_capacityのキャパシティ設定を確認
- [ ] EE拡張（prepend_mod）の内容を確認
