---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-ExpireBuildArtifactsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/expire_build_artifacts_worker.rb`
- E-02: `app/services/ci/job_artifacts/destroy_all_expired_service.rb`
- E-03: `config/initializers/1_settings.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-02 | feature_categoryはjob_artifacts | E-01 (feature_category :job_artifacts) | ○ |
| C-03 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-04 | Feature.enabled?でbulk_delete_job_artifactsをチェック | E-01 (Feature.enabled?(:bulk_delete_job_artifacts, :instance)) | ○ |
| C-05 | DestroyAllExpiredServiceを実行 | E-01 (Ci::JobArtifacts::DestroyAllExpiredService.new.execute) | ○ |
| C-06 | log_extra_metadata_on_doneで削除件数記録 | E-01 (log_extra_metadata_on_done(:destroyed_job_artifacts_count)) | ○ |
| C-07 | BATCH_SIZE = 100 | E-02 (BATCH_SIZE = 100) | ○ |
| C-08 | LOOP_LIMIT = 500 | E-02 (LOOP_LIMIT = 500) | ○ |
| C-09 | LOOP_TIMEOUT = 5.minutes | E-02 (LOOP_TIMEOUT = 5.minutes) | ○ |
| C-10 | LOCK_TIMEOUT = 6.minutes | E-02 (LOCK_TIMEOUT = 6.minutes) | ○ |
| C-11 | EXCLUSIVE_LOCK_KEY = 'expired_job_artifacts:destroy:lock' | E-02 (EXCLUSIVE_LOCK_KEY) | ○ |
| C-12 | expired_before(@start_at)でフィルタ | E-02 (expired_before(@start_at)) | ○ |
| C-13 | non_traceスコープを使用 | E-02 (.non_trace) | ○ |
| C-14 | artifact_unlockedスコープを使用 | E-02 (.artifact_unlocked) | ○ |
| C-15 | limit(BATCH_SIZE)で100件制限 | E-02 (.limit(BATCH_SIZE)) | ○ |
| C-16 | DestroyBatchServiceを使用 | E-02 (Ci::JobArtifacts::DestroyBatchService) | ○ |
| C-17 | skip_projects_on_refresh: true | E-02 (skip_projects_on_refresh: true) | ○ |
| C-18 | ExclusiveLeaseHelpersをinclude | E-02 (include ::Gitlab::ExclusiveLeaseHelpers) | ○ |
| C-19 | cronは`*/7 * * * *` | E-03 (cron設定) | ○ |
| C-20 | カテゴリはアーティファクト管理 | E-04 (バッチ一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] Feature Flag `bulk_delete_job_artifacts`の現在の状態を確認
- [ ] アーティファクトの有効期限設定の確認
- [ ] ストレージ使用量の監視が適切か確認
