---
generated_at: 2026-01-22 14:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：90-DependencyProxy_ImageTtlGroupPolicyWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Expireableモジュールの詳細動作**：モジュール実装が未確認
  2. **監視・アラートの閾値設定**：運用設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/dependency_proxy/image_ttl_group_policy_worker.rb`（ワーカー実装）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | feature_categoryはvirtual_registry | E-01 L11 | ○ |
| C-02 | idempotent!は設定されていない | E-01 L4 rubocop:disable | ○ |
| C-03 | data_consistencyは:sticky | E-01 L9 | ○ |
| C-04 | CronjobQueueを使用 | E-01 L6 | ○ |
| C-05 | DependencyProxy::Expireableをinclude | E-01 L7 | ○ |
| C-06 | ImageTtlGroupPolicy.enabledでポリシー取得 | E-01 L14 | ○ |
| C-07 | group.dependency_proxy_blobs取得 | E-01 L15 | ○ |
| C-08 | group.dependency_proxy_manifests取得 | E-01 L16 | ○ |
| C-09 | active.read_before(policy.ttl)でフィルタ | E-01 L15-16 | ○ |
| C-10 | expire_artifactsでマーク | E-01 L18-19 | ○ |
| C-11 | log_countsでカウント出力 | E-01 L22 | ○ |
| C-12 | pending_destruction, processing, errorカウント出力 | E-01 L28-33 | ○ |
| C-13 | Blob.pending_destruction.count | E-01 L28 | ○ |
| C-14 | Manifest.pending_destruction.count | E-01 L29 | ○ |
| C-15 | バッチ名はDependencyProxy::ImageTtlGroupPolicyWorker | E-02 No.90 | ○ |
| C-16 | カテゴリは依存プロキシ | E-02 No.90 | ○ |
| C-17 | Expireableモジュールの詳細動作 | **根拠なし** | △ |
| C-18 | 監視・アラートの閾値設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DependencyProxy::Expireableモジュールの実装が未確認
  - 候補：app/workers/concerns/dependency_proxy/expireable.rb
- ImageTtlGroupPolicyモデルの実装が未確認
- read_beforeスコープの定義が未確認
- 監視・アラート設定は運用環境に依存するため、本番設定ファイルが必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - idempotentでないため、重複実行時の影響を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] DependencyProxy::Expireableモジュールの実装を確認
- [ ] expire_artifactsメソッドの動作を確認
- [ ] read_beforeスコープの定義を確認
- [ ] ImageTtlGroupPolicyのttlフィールドの単位（日/時間など）を確認
- [ ] idempotentでない理由を確認
