---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-Ci_Catalog_Resources_AggregateLast30DayUsageWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **監視閾値の具体値**：運用ドキュメントからの確認が必要
  2. **Sidekiqリトライ回数**：デフォルト設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/catalog/resources/aggregate_last30_day_usage_worker.rb`
- E-02: `app/services/ci/catalog/resources/aggregate_last30_day_usage_service.rb`
- E-03: `app/models/ci/catalog/resources/components/last_usage.rb`
- E-04: `config/initializers/1_settings.rb`（行804-806）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチは日次0時に実行される | E-04 | ○ |
| C-02 | 最大実行時間は4分（MAX_RUNTIME） | E-01 | ○ |
| C-03 | 重複排除TTLは5分（MAX_RUNTIME + 1分） | E-01 | ○ |
| C-04 | deduplicate :until_executedを使用 | E-01 | ○ |
| C-05 | if_deduplicated: :reschedule_onceを設定 | E-01 | ○ |
| C-06 | feature_categoryはpipeline_composition | E-01 | ○ |
| C-07 | data_consistency :stickyを使用 | E-01 | ○ |
| C-08 | urgency :lowを設定 | E-01 | ○ |
| C-09 | idempotent!で冪等性保証 | E-01 | ○ |
| C-10 | AggregateLast30DayUsageServiceを呼び出す | E-01, E-02 | ○ |
| C-11 | コンポーネントを1000件ずつバッチ処理 | E-02 | ○ |
| C-12 | 過去30日のユニークプロジェクト数を集計 | E-02, E-03 | ○ |
| C-13 | CASE文でバルクUPDATE実行 | E-02 | ○ |
| C-14 | last_30_day_usage_countカラムを更新 | E-02 | ○ |
| C-15 | last_30_day_usage_count_updated_atを更新 | E-02 | ○ |
| C-16 | リソース利用数は配下コンポーネントの合計 | E-02 | ○ |
| C-17 | within_last_30_daysスコープを使用 | E-03 | ○ |
| C-18 | older_than_30_daysスコープが存在 | E-03 | ○ |
| C-19 | テーブル名はcatalog_resource_component_last_usages | E-03 | ○ |
| C-20 | log_hash_metadata_on_doneでログ出力 | E-01 | ○ |
| C-21 | ServiceResponse.successを返す | E-02 | ○ |
| C-22 | cron設定は'0 0 * * *' | E-04 | ○ |
| C-23 | CronjobQueueをinclude | E-01 | ○ |
| C-24 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |
| C-25 | 監視閾値4分超過でアラート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定
- 監視・アラートの閾値設定
  - 候補：運用ドキュメント / Prometheus設定 / アラートルール定義

## 5) リスクフラグ（レビュー観点）
- 0: パフォーマンス（バッチサイズ1000件は適切に設定済み）
- 0: 重複排除（deduplicate設定が適切）
- 1: 監視設定の具体値が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_RUNTIME（4分）が実運用で適切か確認
- [ ] バッチサイズ1000件がメモリ使用量の観点で適切か確認
- [ ] 監視・アラート設定が運用環境に存在するか確認
- [ ] CleanupLastUsagesWorkerとの実行順序に問題がないか確認
