---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：92-Ci_Catalog_Resources_CleanupLastUsagesWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/catalog/resources/cleanup_last_usages_worker.rb`
- E-02: `app/models/ci/catalog/resources/components/last_usage.rb`
- E-03: `config/initializers/1_settings.rb`（行807-809）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチは日次0時に実行される | E-03 | ○ |
| C-02 | cron設定は'0 0 * * *' | E-03 | ○ |
| C-03 | feature_categoryはpipeline_composition | E-01 | ○ |
| C-04 | data_consistency :stickyを使用 | E-01 | ○ |
| C-05 | urgency :lowを設定 | E-01 | ○ |
| C-06 | idempotent!で冪等性保証 | E-01 | ○ |
| C-07 | CronjobQueueをinclude | E-01 | ○ |
| C-08 | バッチサイズは1000件 | E-01 | ○ |
| C-09 | each_batchメソッドを使用 | E-01 | ○ |
| C-10 | delete_allで一括削除 | E-01 | ○ |
| C-11 | older_than_30_daysスコープを使用 | E-01, E-02 | ○ |
| C-12 | 30日より前のレコードを削除対象とする | E-02 | ○ |
| C-13 | テーブル名はcatalog_resource_component_last_usages | E-02 | ○ |
| C-14 | EachBatchモジュールをinclude | E-02 | ○ |
| C-15 | last_used_dateカラムで日付判定 | E-02 | ○ |
| C-16 | within_last_30_daysスコープも定義されている | E-02 | ○ |
| C-17 | AggregateLast30DayUsageWorkerと同時刻に実行 | E-03 | ○ |
| C-18 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 0: データ整合性（within_last_30_daysとolder_than_30_daysで境界が明確）
- 0: パフォーマンス（バッチサイズ1000件は適切）
- 0: 冪等性（idempotent!で保証）

## 6) レビュアーチェックリスト（最小）
- [ ] バッチサイズ1000件がパフォーマンスの観点で適切か確認
- [ ] AggregateLast30DayUsageWorkerとの実行順序に問題がないか確認
- [ ] 30日境界の日付計算が正しいか確認（タイムゾーン考慮）
