---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：93-Ci_Catalog_Resources_ProcessSyncEventsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **sync!メソッドの具体的な同期内容**：Ci::Catalog::Resourceモデルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/catalog/resources/process_sync_events_worker.rb`
- E-02: `app/services/ci/process_sync_events_service.rb`
- E-03: `config/initializers/1_settings.rb`（行795-797）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'*/1 * * * *'（毎分） | E-03 | ○ |
| C-02 | feature_categoryはpipeline_composition | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | urgency :highを設定 | E-01 | ○ |
| C-05 | idempotent!で冪等性保証 | E-01 | ○ |
| C-06 | CronjobQueueをinclude | E-01 | ○ |
| C-07 | deduplicate :until_executedを使用 | E-01 | ○ |
| C-08 | if_deduplicated: :reschedule_onceを設定 | E-01 | ○ |
| C-09 | TTLは1分 | E-01 | ○ |
| C-10 | ProcessSyncEventsServiceを使用 | E-01, E-02 | ○ |
| C-11 | BATCH_SIZEは1000 | E-02 | ○ |
| C-12 | ExclusiveLeaseGuardをinclude | E-02 | ○ |
| C-13 | lease_timeoutは1分 | E-02 | ○ |
| C-14 | try_obtain_leaseでロック取得 | E-02 | ○ |
| C-15 | unprocessed_eventsスコープを使用 | E-02 | ○ |
| C-16 | preload_synced_relationを使用 | E-02 | ○ |
| C-17 | sync_classのsync!メソッドを呼び出す | E-02 | ○ |
| C-18 | mark_records_processedで処理済みマーク | E-02 | ○ |
| C-19 | 残りイベント時にenqueue_workerを呼び出す | E-02 | ○ |
| C-20 | estimated_total_eventsをログ出力 | E-02 | ○ |
| C-21 | consumable_eventsをログ出力 | E-02 | ○ |
| C-22 | processed_eventsをログ出力 | E-02 | ○ |
| C-23 | log_extra_metadata_on_doneでメタデータ出力 | E-01 | ○ |
| C-24 | 3つのトリガー方式（コールバック/cron/再スケジュール） | E-01コメント | ○ |
| C-25 | Projectモデルコールバックで実行される | E-01コメント | ○ |
| C-26 | sync!で名前・説明・可視性等を同期 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Ci::Catalog::Resourceモデルのsync!メソッドの実装詳細
  - 候補：`app/models/ci/catalog/resource.rb` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 排他制御（ExclusiveLeaseGuardで適切に実装）
- 0: 重複排除（deduplicateで適切に設定）
- 1: sync!メソッドの具体的動作が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::Catalog::Resource.sync!メソッドが実際に存在し、期待通りに動作するか確認
- [ ] SyncEventテーブルのスキーマとprocessedカラムの確認
- [ ] 高優先度（urgency :high）設定が適切か確認
- [ ] 1分のlease_timeoutが十分か確認
