---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：94-Ci_Runners_ReconcileExistingRunnerVersionsCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/runners/reconcile_existing_runner_versions_cron_worker.rb`
- E-02: `app/services/ci/runners/reconcile_existing_runner_versions_service.rb`
- E-03: `config/initializers/1_settings.rb`（行768-770）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'@daily' | E-03 | ○ |
| C-02 | feature_categoryはfleet_visibility | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | urgency :lowを設定 | E-01 | ○ |
| C-05 | idempotent!で冪等性保証 | E-01 | ○ |
| C-06 | CronjobQueueをinclude | E-01 | ○ |
| C-07 | deduplicate :until_executedを使用 | E-01 | ○ |
| C-08 | cronjob_scheduledパラメータを受け取る | E-01 | ○ |
| C-09 | ランダム遅延は0〜12時間 | E-01 | ○ |
| C-10 | perform_inで再スケジュール | E-01 | ○ |
| C-11 | ReconcileExistingRunnerVersionsServiceを使用 | E-01, E-02 | ○ |
| C-12 | VERSION_BATCH_SIZEは100 | E-02 | ○ |
| C-13 | distinct_each_batchでバージョン取得 | E-02 | ○ |
| C-14 | insert_allで新バージョン追加 | E-02 | ○ |
| C-15 | unique_by: :versionで重複防止 | E-02 | ○ |
| C-16 | cleanup_runner_versionsで不要バージョン削除 | E-02 | ○ |
| C-17 | potentially_outdatedスコープを使用 | E-02 | ○ |
| C-18 | RunnerUpgradeCheckでステータス判定 | E-02 | ○ |
| C-19 | upsert_allでステータス更新 | E-02 | ○ |
| C-20 | total_inserted/updated/deletedをログ出力 | E-02 | ○ |
| C-21 | log_hash_metadata_on_doneでメタデータ出力 | E-01 | ○ |
| C-22 | ServiceResponse.successを返す | E-02 | ○ |
| C-23 | Sidekiq.loggerで再スケジュールをログ出力 | E-01 | ○ |
| C-24 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 0: ランダム遅延（API負荷分散が適切に実装）
- 0: 重複排除（deduplicateで適切に設定）
- 1: GitLab Releases APIの可用性依存

## 6) レビュアーチェックリスト（最小）
- [ ] GitLab Releases APIの障害時の動作確認
- [ ] ランダム遅延が運用上問題ないか確認
- [ ] ci_runner_versionsテーブルのステータス値の定義確認
- [ ] RunnerUpgradeCheckクラスの判定ロジック確認
