---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：95-Ci_Runners_StaleMachinesCleanupCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **staleスコープの定義**：Ci::RunnerManagerモデルの確認が必要
  2. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/runners/stale_machines_cleanup_cron_worker.rb`
- E-02: `app/services/ci/runners/stale_managers_cleanup_service.rb`
- E-03: `config/initializers/1_settings.rb`（行774-776）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'36 * * * *'（毎時36分） | E-03 | ○ |
| C-02 | feature_categoryはfleet_visibility | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | urgency :lowを設定 | E-01 | ○ |
| C-05 | idempotent!で冪等性保証 | E-01 | ○ |
| C-06 | CronjobQueueをinclude | E-01 | ○ |
| C-07 | StaleManagersCleanupServiceを使用 | E-01, E-02 | ○ |
| C-08 | MAX_DELETIONSは1000 | E-02 | ○ |
| C-09 | SUB_BATCH_LIMITは100 | E-02 | ○ |
| C-10 | staleスコープで対象を抽出 | E-02 | ○ |
| C-11 | id_inとdelete_allで削除 | E-02 | ○ |
| C-12 | ループで削除件数が0まで継続 | E-02 | ○ |
| C-13 | 総削除数がMAX_DELETIONSに達したら終了 | E-02 | ○ |
| C-14 | total_deletedを返す | E-02 | ○ |
| C-15 | batch_countsを返す | E-02 | ○ |
| C-16 | log_extra_metadata_on_doneでstatus出力 | E-01 | ○ |
| C-17 | log_hash_metadata_on_doneでpayload出力 | E-01 | ○ |
| C-18 | staleスコープはRunnerManagerモデルで定義 | **根拠なし** | △ |
| C-19 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Ci::RunnerManager（ci_runner_machines）のstaleスコープの定義
  - 候補：`app/models/ci/runner_manager.rb` の確認が必要
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 1: staleスコープの定義が未確認（削除条件の妥当性確認が必要）
- 0: 削除上限設定（MAX_DELETIONSで制御されている）
- 0: 冪等性（idempotent!で保証）

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::RunnerManagerモデルのstaleスコープの定義確認
- [ ] stale判定の閾値（何日間接続がないとstaleか）確認
- [ ] MAX_DELETIONS（1000件）が運用上適切か確認
- [ ] 毎時実行の頻度が適切か確認
