---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 23
  claims_with_evidence: 21
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：96-Ci_ScheduleOldPipelinesRemovalCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：21 / 23、根拠なし：2
- 優先レビュー（高）
  1. **AutoCleanupServiceの詳細**：サービスクラスの実装確認が必要
  2. **ProjectsCleanupQueueの動作**：キュー実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/schedule_old_pipelines_removal_cron_worker.rb`
- E-02: `app/workers/ci/destroy_old_pipelines_worker.rb`
- E-03: `config/initializers/1_settings.rb`（行823-825）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'*/11 * * * *'（11分ごと） | E-03 | ○ |
| C-02 | feature_categoryはcontinuous_integration | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | urgency :lowを設定 | E-01 | ○ |
| C-05 | idempotent!で冪等性保証 | E-01 | ○ |
| C-06 | CronjobQueueをinclude | E-01 | ○ |
| C-07 | deduplicate :until_executed, including_scheduled: trueを使用 | E-01 | ○ |
| C-08 | ProjectsCleanupQueue.instance.enqueue_projects!を呼び出す | E-01 | ○ |
| C-09 | DestroyOldPipelinesWorker.perform_with_capacityを呼び出す | E-01 | ○ |
| C-10 | DestroyOldPipelinesWorkerはLimitedCapacity::Workerをinclude | E-02 | ○ |
| C-11 | CONCURRENCYは10 | E-02 | ○ |
| C-12 | LIMITは250 | E-02 | ○ |
| C-13 | RE_ENQUEUE_THRESHOLDは100 | E-02 | ○ |
| C-14 | cleanup_queueからfetch_next_project_id!で取得 | E-02 | ○ |
| C-15 | AutoCleanupServiceでパイプライン削除 | E-02 | ○ |
| C-16 | 削除件数/スキップ件数がRE_ENQUEUE_THRESHOLD超で再キュー | E-02 | ○ |
| C-17 | log_extra_metadata_on_doneでremoved_count出力 | E-02 | ○ |
| C-18 | log_extra_metadata_on_doneでskipped_count出力 | E-02 | ○ |
| C-19 | log_extra_metadata_on_doneでproject出力 | E-02 | ○ |
| C-20 | CronjobChildWorkerをinclude | E-02 | ○ |
| C-21 | Feature flagでprotectedパイプラインをスキップ可能 | E-02 | ○ |
| C-22 | AutoCleanupServiceの詳細動作 | **根拠なし** | △ |
| C-23 | ProjectsCleanupQueueの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Ci::Pipelines::AutoCleanupServiceの実装詳細
  - 候補：`app/services/ci/pipelines/auto_cleanup_service.rb` の確認が必要
- Ci::RetentionPolicies::ProjectsCleanupQueueの実装詳細
  - 候補：`lib/ci/retention_policies/projects_cleanup_queue.rb` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 並列実行制御（LimitedCapacity::Workerで適切に制御）
- 0: 重複排除（deduplicateで適切に設定）
- 1: AutoCleanupServiceの削除ロジック未確認
- 1: 保持ポリシーの設定方法未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::Pipelines::AutoCleanupServiceの削除ロジック確認
- [ ] ProjectsCleanupQueueのキュー管理方法確認
- [ ] CI保持ポリシーの設定方法と対象プロジェクトの選定ロジック確認
- [ ] Feature flag（ci_skip_old_protected_pipelines, ci_skip_locked_pipelines）の動作確認
