---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：97-Ci_ScheduleUnlockPipelinesInQueueCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **UnlockPipelinesInQueueWorkerの詳細**：実際のロック解除ロジックの確認が必要
  2. **キューの実装詳細**：ロック解除キューの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/schedule_unlock_pipelines_in_queue_cron_worker.rb`
- E-02: `config/initializers/1_settings.rb`（行792-794）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'*/1 * * * *'（毎分） | E-02 | ○ |
| C-02 | feature_categoryはjob_artifacts | E-01 | ○ |
| C-03 | data_consistency :alwaysを使用 | E-01 | ○ |
| C-04 | idempotent!で冪等性保証 | E-01 | ○ |
| C-05 | CronjobQueueをinclude | E-01 | ○ |
| C-06 | UnlockPipelinesInQueueWorker.perform_with_capacityを呼び出す | E-01 | ○ |
| C-07 | スプラット演算子(...)で引数転送 | E-01 | ○ |
| C-08 | performメソッドは可変引数を受け取る | E-01 | ○ |
| C-09 | シンプルなスケジューラ実装 | E-01 | ○ |
| C-10 | コメントでscoped to contextでないことを明記 | E-01 | ○ |
| C-11 | rubocop:disableでScalability/CronWorkerContextを除外 | E-01 | ○ |
| C-12 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |
| C-13 | UnlockPipelinesInQueueWorkerのロック解除ロジック | **根拠なし** | △ |
| C-14 | urgency設定なし（デフォルト） | E-01 | ○ |
| C-15 | deduplicate設定なし | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- Ci::UnlockPipelinesInQueueWorkerの実装詳細
  - 候補：`app/workers/ci/unlock_pipelines_in_queue_worker.rb` の確認が必要
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 1: 実際のロック解除ロジックが未確認
- 0: 冪等性（idempotent!で保証）
- 0: データ整合性（data_consistency :alwaysで保証）

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::UnlockPipelinesInQueueWorkerの実装確認
- [ ] ロック解除キューの実装と動作確認
- [ ] パイプラインのロック状態カラムの定義確認
- [ ] LimitedCapacity::Workerの並列数設定確認
