---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：98-Ci_DeleteUnitTestsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **deletableスコープの定義**：モデルの実装確認が必要
  2. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/delete_unit_tests_worker.rb`
- E-02: `app/services/ci/delete_unit_tests_service.rb`
- E-03: `config/initializers/1_settings.rb`（行717-719）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'0 0 * * *'（毎日0時） | E-03 | ○ |
| C-02 | feature_categoryはcode_testing | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | idempotent!で冪等性保証 | E-01 | ○ |
| C-05 | CronjobQueueをinclude | E-01 | ○ |
| C-06 | DeleteUnitTestsServiceを呼び出す | E-01, E-02 | ○ |
| C-07 | BATCH_SIZEは100 | E-02 | ○ |
| C-08 | EachBatchモジュールをinclude | E-02 | ○ |
| C-09 | UnitTestFailureを先に削除 | E-02 | ○ |
| C-10 | UnitTestを後で削除 | E-02 | ○ |
| C-11 | purge_data!メソッドで削除ループ | E-02 | ○ |
| C-12 | delete_batch!メソッドで実際の削除 | E-02 | ○ |
| C-13 | deletableスコープを使用 | E-02 | ○ |
| C-14 | FOR UPDATE SKIP LOCKEDでロック | E-02 | ○ |
| C-15 | トランザクション内で削除 | E-02 | ○ |
| C-16 | delete_allで一括削除 | E-02 | ○ |
| C-17 | 削除件数が0になるまでループ | E-02 | ○ |
| C-18 | コメントでscoped to contextでないことを明記 | E-01 | ○ |
| C-19 | deletableスコープの定義内容 | **根拠なし** | △ |
| C-20 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Ci::UnitTestとCi::UnitTestFailureのdeletableスコープの定義
  - 候補：`app/models/ci/unit_test.rb`, `app/models/ci/unit_test_failure.rb` の確認が必要
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 1: deletableスコープの定義が未確認（削除条件の妥当性確認が必要）
- 0: 競合回避（FOR UPDATE SKIP LOCKEDで適切に実装）
- 0: 冪等性（idempotent!で保証）

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::UnitTestのdeletableスコープの定義確認
- [ ] Ci::UnitTestFailureのdeletableスコープの定義確認
- [ ] 外部キー制約により削除順序が正しいか確認
- [ ] BATCH_SIZE（100件）がパフォーマンスの観点で適切か確認
