---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：99-Ci_DeleteExpiredTriggerTokenWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/delete_expired_trigger_token_worker.rb`
- E-02: `app/models/ci/trigger.rb`
- E-03: `config/initializers/1_settings.rb`（行527-529）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'0 0 * * *'（毎日0時） | E-03 | ○ |
| C-02 | feature_categoryはcontinuous_integration | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | idempotent!で冪等性保証 | E-01 | ○ |
| C-05 | queue_namespace :cronjobを使用 | E-01 | ○ |
| C-06 | BATCH_SIZEは100 | E-01 | ○ |
| C-07 | each_batchでバッチ処理 | E-01 | ○ |
| C-08 | delete_allで一括削除 | E-01 | ○ |
| C-09 | ready_for_deletionスコープを使用 | E-01, E-02 | ○ |
| C-10 | EXPIRED_TOKEN_RETENTIONは30日 | E-02 | ○ |
| C-11 | expires_at < 30日前 の条件 | E-02 | ○ |
| C-12 | TRIGGER_TOKEN_PREFIXは'glptt-' | E-02 | ○ |
| C-13 | token_encryptedカラムで暗号化保存 | E-02 | ○ |
| C-14 | Ci::Triggerモデルを操作 | E-01, E-02 | ○ |
| C-15 | プロジェクトに属するトークン | E-02 | ○ |
| C-16 | オーナーに属するトークン | E-02 | ○ |
| C-17 | パイプラインとの関連（has_many :pipelines） | E-02 | ○ |
| C-18 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 0: 削除条件（30日の保持期間が設定されており安全）
- 0: 冪等性（idempotent!で保証）
- 0: バッチ処理（100件ずつで適切）

## 6) レビュアーチェックリスト（最小）
- [ ] 30日の保持期間（EXPIRED_TOKEN_RETENTION）が運用上適切か確認
- [ ] バッチサイズ100件がパフォーマンスの観点で適切か確認
- [ ] パイプラインとの外部キー制約の有無確認（削除時のカスケード動作）
