---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 99
  claims_with_evidence: 99
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：achievements 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：99 / 99、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/achievements/achievement.rb` - Achievementモデル定義
- E-02: `app/models/achievements/user_achievement.rb` - UserAchievementモデル定義
- E-03: `app/services/achievements/base_service.rb` - BaseService基底クラス
- E-04: `app/services/achievements/create_service.rb` - Achievement作成サービス
- E-05: `app/services/achievements/update_service.rb` - Achievement更新サービス
- E-06: `app/services/achievements/destroy_service.rb` - Achievement削除サービス
- E-07: `app/services/achievements/award_service.rb` - Achievement授与サービス
- E-08: `app/services/achievements/revoke_service.rb` - Achievement取り消しサービス
- E-09: `app/services/achievements/destroy_user_achievement_service.rb` - UserAchievement削除サービス
- E-10: `app/services/achievements/update_user_achievement_service.rb` - UserAchievement更新サービス
- E-11: `app/services/achievements/update_user_achievement_priorities_service.rb` - 優先度一括更新サービス
- E-12: `app/finders/achievements/achievements_finder.rb` - Achievementファインダー
- E-13: `app/policies/achievements/achievement_policy.rb` - Achievementポリシー
- E-14: `app/policies/achievements/user_achievement_policy.rb` - UserAchievementポリシー
- E-15: `app/graphql/resolvers/achievements/achievements_resolver.rb` - AchievementsResolver
- E-16: `app/graphql/resolvers/achievements/user_achievements_resolver.rb` - UserAchievementsResolver
- E-17: `spec/models/achievements/achievement_spec.rb` - Achievementモデルテスト（既存）
- E-18: `spec/models/achievements/user_achievement_spec.rb` - UserAchievementモデルテスト（既存）

## 3) Claims と根拠の対応（レビューの主戦場）

### Achievements::Achievement モデル（UT-ACH-001 〜 UT-ACH-019）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :namespace リレーション | E-01 (line 8) | ○ |
| C-02 | namespace必須（optional: false） | E-01 (line 8) | ○ |
| C-03 | has_many :user_achievements リレーション | E-01 (line 10) | ○ |
| C-04 | has_many :users through リレーション | E-01 (line 11) | ○ |
| C-05 | name presence バリデーション | E-01 (line 15-16) | ○ |
| C-06 | name 空文字バリデーション | E-01 (line 15) | ○ |
| C-07 | name 最大255文字制限 | E-01 (line 17) | ○ |
| C-08 | name 256文字でエラー | E-01 (line 17) | ○ |
| C-09 | name ユニーク制約（同一namespace） | E-01 (line 18) | ○ |
| C-10 | name ユニーク制約（別namespace許可） | E-01 (line 18) | ○ |
| C-11 | name 大文字小文字無視 | E-01 (line 18) | ○ |
| C-12 | description 最大1024文字制限 | E-01 (line 19) | ○ |
| C-13 | description 1025文字でエラー | E-01 (line 19) | ○ |
| C-14 | description 任意項目 | E-01 (line 19) | ○ |
| C-15 | name strip_attributes | E-01 (line 13), E-17 (line 22-29) | ○ |
| C-16 | description strip_attributes | E-01 (line 13) | ○ |
| C-17 | unique_users 重複排除 | E-01 (line 21-23), E-17 (line 45-58) | ○ |
| C-18 | unique_users 空の場合 | E-17 (line 60-63) | ○ |
| C-19 | uploads_sharding_key | E-01 (line 25-27), E-17 (line 36-42) | ○ |

### Achievements::UserAchievement モデル（UT-ACH-020 〜 UT-ACH-038）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | belongs_to :achievement リレーション | E-02 (line 5) | ○ |
| C-21 | achievement必須 | E-02 (line 5) | ○ |
| C-22 | belongs_to :user リレーション | E-02 (line 6) | ○ |
| C-23 | user必須 | E-02 (line 6) | ○ |
| C-24 | belongs_to :awarded_by_user リレーション | E-02 (line 8-11) | ○ |
| C-25 | awarded_by_user必須 | E-02 (line 11) | ○ |
| C-26 | belongs_to :revoked_by_user リレーション | E-02 (line 12-15) | ○ |
| C-27 | revoked_by_user任意 | E-02 (line 15) | ○ |
| C-28 | scope :not_revoked | E-02 (line 17), E-18 (line 35-38) | ○ |
| C-29 | not_revoked 全取り消し時 | E-02 (line 17) | ○ |
| C-30 | scope :shown_on_profile | E-02 (line 18), E-18 (line 41-44) | ○ |
| C-31 | scope :order_by_priority_asc | E-02 (line 19-33) | ○ |
| C-32 | order_by_priority_asc nulls_last | E-02 (line 24) | ○ |
| C-33 | scope :order_by_id_asc | E-02 (line 34) | ○ |
| C-34 | show_on_profile=true許可 | E-02 (line 36), E-18 (line 49) | ○ |
| C-35 | show_on_profile=false許可 | E-02 (line 36), E-18 (line 49) | ○ |
| C-36 | show_on_profile=nil不許可 | E-02 (line 36), E-18 (line 50) | ○ |
| C-37 | revoked? true判定 | E-02 (line 38-40), E-18 (line 14-19) | ○ |
| C-38 | revoked? false判定 | E-02 (line 38-40), E-18 (line 21-26) | ○ |

### サービスクラス（UT-ACH-039 〜 UT-ACH-081）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | BaseService initialize | E-03 (line 5-8) | ○ |
| C-40 | BaseService allowed? 権限あり | E-03 (line 12-13) | ○ |
| C-41 | BaseService allowed? 権限なし | E-03 (line 12-13) | ○ |
| C-42 | BaseService allowed? nil安全 | E-03 (line 13) | ○ |
| C-43 | BaseService error | E-03 (line 15-17) | ○ |
| C-44 | CreateService 正常作成 | E-04 (line 5-12) | ○ |
| C-45 | CreateService 権限エラー | E-04 (line 6, 17-19) | ○ |
| C-46 | CreateService バリデーションエラー | E-04 (line 10, 21-23) | ○ |
| C-47 | CreateService namespace_id自動設定 | E-04 (line 8) | ○ |
| C-48 | UpdateService 正常更新 | E-05 (line 13-20) | ○ |
| C-49 | UpdateService 権限エラー | E-05 (line 14, 29-31) | ○ |
| C-50 | UpdateService バリデーションエラー | E-05 (line 19, 37-39) | ○ |
| C-51 | UpdateService nil安全 | E-05 (line 26) | ○ |
| C-52 | DestroyService 正常削除 | E-06 (line 12-16) | ○ |
| C-53 | DestroyService 権限エラー | E-06 (line 13, 25-27) | ○ |
| C-54 | DestroyService deleteメソッド | E-06 (line 15) | ○ |
| C-55 | AwardService 正常授与 | E-07 (line 13-26) | ○ |
| C-56 | AwardService 通知送信 | E-07 (line 25) | ○ |
| C-57 | AwardService 権限エラー | E-07 (line 15, 37-39) | ○ |
| C-58 | AwardService RecordNotFound achievement | E-07 (line 27-28) | ○ |
| C-59 | AwardService RecordNotFound recipient | E-07 (line 17, 27-28) | ○ |
| C-60 | AwardService 作成失敗 | E-07 (line 23, 41-43) | ○ |
| C-61 | RevokeService 正常取り消し | E-08 (line 12-22) | ○ |
| C-62 | RevokeService 属性設定 | E-08 (line 16-19) | ○ |
| C-63 | RevokeService 権限エラー | E-08 (line 13, 31-33) | ○ |
| C-64 | RevokeService 二重取り消し防止 | E-08 (line 14, 35-37) | ○ |
| C-65 | RevokeService 保存失敗 | E-08 (line 20, 39-41) | ○ |
| C-66 | DestroyUserAchievementService 正常削除 | E-09 (line 12-16) | ○ |
| C-67 | DestroyUserAchievementService 権限エラー | E-09 (line 13, 25-27) | ○ |
| C-68 | UpdateUserAchievementService 正常更新 | E-10 (line 14-21) | ○ |
| C-69 | UpdateUserAchievementService 権限エラー | E-10 (line 15, 30-32) | ○ |
| C-70 | UpdateUserAchievementService バリデーション | E-10 (line 20, 38-40) | ○ |
| C-71 | UpdateUserAchievementPrioritiesService 一括更新 | E-11 (line 12-27) | ○ |
| C-72 | UpdateUserAchievementPrioritiesService 優先度設定 | E-11 (line 15) | ○ |
| C-73 | UpdateUserAchievementPrioritiesService 優先度クリア | E-11 (line 20) | ○ |
| C-74 | UpdateUserAchievementPrioritiesService 部分権限エラー | E-11 (line 32-33, 40-42) | ○ |
| C-75 | UpdateUserAchievementPrioritiesService 空配列 | E-11 (line 23) | ○ |
| C-76 | UpdateUserAchievementPrioritiesService BulkUpdate | E-11 (line 25) | ○ |
| C-77 | AchievementsFinder 基本取得 | E-12 (line 12-14) | ○ |
| C-78 | AchievementsFinder IDフィルタ | E-12 (line 19-22, 24-26) | ○ |
| C-79 | AchievementsFinder フィルタなし | E-12 (line 20) | ○ |
| C-80 | AchievementsFinder 空配列対応 | E-12 (line 24-26) | ○ |
| C-81 | AchievementsFinder by_ids | E-12 (line 19-22) | ○ |

### ポリシークラス（UT-ACH-082 〜 UT-ACH-092）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | AchievementPolicy delegate namespace | E-13 (line 5) | ○ |
| C-83 | AchievementPolicy achievement_recipient条件 | E-13 (line 7-12) | ○ |
| C-84 | AchievementPolicy 非受賞者 | E-13 (line 7-12) | ○ |
| C-85 | UserAchievementPolicy delegate achievement | E-14 (line 5) | ○ |
| C-86 | UserAchievementPolicy delegate namespace | E-14 (line 6) | ○ |
| C-87 | UserAchievementPolicy delegate user | E-14 (line 7) | ○ |
| C-88 | UserAchievementPolicy user_is_recipient条件 | E-14 (line 9, 13) | ○ |
| C-89 | UserAchievementPolicy 他人制限 | E-14 (line 9, 13) | ○ |
| C-90 | UserAchievementPolicy read_user_achievement | E-14 (line 11) | ○ |
| C-91 | UserAchievementPolicy update_user_achievement | E-14 (line 15) | ○ |
| C-92 | UserAchievementPolicy prevent rules | E-14 (line 17-20) | ○ |

### GraphQL Resolver（UT-ACH-093 〜 UT-ACH-099）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | AchievementsResolver Feature有効時 | E-15 (line 16-23) | ○ |
| C-94 | AchievementsResolver Feature無効時 | E-15 (line 17) | ○ |
| C-95 | AchievementsResolver ids引数処理 | E-15 (line 19-20) | ○ |
| C-96 | AchievementsResolver preloads | E-15 (line 28-31) | ○ |
| C-97 | UserAchievementsResolver not_revoked | E-16 (line 10-13) | ○ |
| C-98 | UserAchievementsResolver unconditional_includes | E-16 (line 17-21) | ○ |
| C-99 | UserAchievementsResolver preloads | E-16 (line 23-28) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、既存テストファイル（spec/models/achievements/）とも整合性があります

## 6) レビュアーチェックリスト（最小）
- [ ] モデルのリレーション定義が正しく反映されているか確認
- [ ] バリデーションの境界値テストが適切か確認
- [ ] サービスクラスの権限チェックパターンが網羅されているか確認
- [ ] ポリシークラスの条件分岐が全てカバーされているか確認
- [ ] 既存テスト（spec/models/achievements/）と重複・矛盾がないか確認
- [ ] GraphQL Resolverの機能フラグ処理が正しく反映されているか確認
