---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 135
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：alert_management単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：135 / 135、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/alert_management/alert.rb` - Alertモデル定義
- E-02: `app/models/alert_management/alert_user_mention.rb` - AlertUserMentionモデル定義
- E-03: `app/models/alert_management/http_integration.rb` - HttpIntegrationモデル定義
- E-04: `app/models/alert_management/alert_assignee.rb` - AlertAssigneeモデル定義
- E-05: `app/models/alert_management/metric_image.rb` - MetricImageモデル定義
- E-06: `app/services/alert_management/http_integrations/create_service.rb` - HTTP統合作成サービス
- E-07: `app/services/alert_management/http_integrations/update_service.rb` - HTTP統合更新サービス
- E-08: `app/services/alert_management/http_integrations/destroy_service.rb` - HTTP統合削除サービス
- E-09: `app/services/alert_management/http_integrations/base_service.rb` - HTTP統合ベースサービス
- E-10: `app/services/alert_management/alerts/update_service.rb` - アラート更新サービス
- E-11: `app/services/alert_management/alerts/todo/create_service.rb` - Todo作成サービス
- E-12: `app/services/alert_management/create_alert_issue_service.rb` - Issue作成サービス
- E-13: `app/services/alert_management/process_prometheus_alert_service.rb` - Prometheusアラート処理サービス
- E-14: `app/services/alert_management/metric_images/upload_service.rb` - メトリック画像アップロードサービス
- E-15: `app/finders/alert_management/alerts_finder.rb` - アラート検索Finder
- E-16: `app/finders/alert_management/http_integrations_finder.rb` - HTTP統合検索Finder
- E-17: `app/presenters/alert_management/alert_presenter.rb` - アラートプレゼンター
- E-18: `app/services/concerns/alert_management/alert_processing.rb` - アラート処理Concern
- E-19: `app/services/concerns/alert_management/responses.rb` - レスポンスConcern

## 3) Claims と根拠の対応（レビューの主戦場）

### Alertモデル (UT-ALM-001 ~ UT-ALM-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :projectリレーション | E-01 L22 | ○ |
| C-02 | belongs_to :issueリレーション | E-01 L23 | ○ |
| C-03 | belongs_to :issueのoptional設定 | E-01 L23 `optional: true` | ○ |
| C-04 | belongs_to :environmentリレーション | E-01 L24 | ○ |
| C-05 | has_many :alert_assigneesリレーション | E-01 L26-27 | ○ |
| C-06 | has_many :notesリレーション | E-01 L29-30 | ○ |
| C-07 | has_many :metric_imagesリレーション | E-01 L33 | ○ |
| C-08 | validates :title presence | E-01 L48 | ○ |
| C-09 | TITLE_MAX_LENGTH=200 | E-01 L42, L48 | ○ |
| C-10 | title 201文字超過エラー | E-01 L42, L48 | ○ |
| C-11 | DESCRIPTION_MAX_LENGTH=1000 | E-01 L43, L49 | ○ |
| C-12 | description 1001文字超過エラー | E-01 L43, L49 | ○ |
| C-13 | SERVICE_MAX_LENGTH=100 | E-01 L44, L50 | ○ |
| C-14 | TOOL_MAX_LENGTH=100 | E-01 L45, L51 | ○ |
| C-15 | fingerprintのuniqueness（未解決時） | E-01 L56-60 | ○ |
| C-16 | 解決済み時のfingerprint重複許可 | E-01 L60 `unless: :resolved?` | ○ |
| C-17 | HOSTS_MAX_LENGTH=255 | E-01 L46, L188 | ○ |
| C-18 | hosts配列ネスト禁止 | E-01 L189 | ○ |
| C-19 | enum :severity定義 | E-01 L63-70 | ○ |
| C-20 | enum :domain定義 | E-01 L72-75 | ○ |
| C-21 | scope :for_iid | E-01 L80 | ○ |
| C-22 | scope :for_fingerprint | E-01 L81 | ○ |
| C-23 | scope :not_resolved | E-01 L85 | ○ |
| C-24 | scope :search | E-01 L84 | ○ |
| C-25 | scope :order_severity | E-01 L95-96 | ○ |
| C-26 | counts_by_statusメソッド | E-01 L102-104 | ○ |
| C-27 | sort_by_attribute started_at_asc | E-01 L106-121 | ○ |
| C-28 | sort_by_attribute event_count_desc | E-01 L106-121 | ○ |
| C-29 | find_unresolved_alert（発見） | E-01 L123-125 | ○ |
| C-30 | find_unresolved_alert（未発見） | E-01 L123-125 | ○ |
| C-31 | prometheus?メソッド（true） | E-01 L147-149 | ○ |
| C-32 | prometheus?メソッド（false） | E-01 L147-149 | ○ |
| C-33 | register_new_event! | E-01 L151-153 | ○ |
| C-34 | to_reference | E-01 L155-159 | ○ |
| C-35 | reference_valid?（有効） | E-01 L143-145 | ○ |
| C-36 | reference_valid?（無効） | E-01 L143-145 | ○ |
| C-37 | parsed_payload | E-01 L169-173 | ○ |
| C-38 | execute_integrations（実行） | E-01 L161-165 | ○ |
| C-39 | execute_integrations（スキップ） | E-01 L162 | ○ |

### AlertUserMentionモデル (UT-ALM-040 ~ UT-ALM-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | belongs_to :alert | E-02 L5-7 | ○ |
| C-41 | belongs_to :note | E-02 L9 | ○ |

### HttpIntegrationモデル (UT-ALM-042 ~ UT-ALM-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | belongs_to :project | E-03 L10 | ○ |
| C-43 | tokenの形式バリデーション（有効） | E-03 L21 | ○ |
| C-44 | tokenの形式バリデーション（無効） | E-03 L21 | ○ |
| C-45 | name presence | E-03 L22 | ○ |
| C-46 | name最大長255 | E-03 L22 | ○ |
| C-47 | endpoint_identifier形式（有効） | E-03 L24 | ○ |
| C-48 | endpoint_identifier形式（無効） | E-03 L24 | ○ |
| C-49 | endpoint_identifier uniqueness | E-03 L25 | ○ |
| C-50 | enum :type_identifier http | E-03 L39-42 | ○ |
| C-51 | enum :type_identifier prometheus | E-03 L39-42 | ○ |
| C-52 | url（legacy） | E-03 L44-53 | ○ |
| C-53 | url（legacy-prometheus） | E-03 L44-53 | ○ |
| C-54 | url（通常） | E-03 L44-53 | ○ |
| C-55 | legacy?（true） | E-03 L55-57, L8 | ○ |
| C-56 | legacy?（false） | E-03 L55-57, L8 | ○ |
| C-57 | prevent_token_assignment | E-03 L70-76 | ○ |
| C-58 | ensure_token | E-03 L78-80 | ○ |
| C-59 | prevent_endpoint_identifier_assignment | E-03 L82-86 | ○ |
| C-60 | ensure_payload_example_not_nil | E-03 L88-90 | ○ |

### AlertAssigneeモデル (UT-ALM-061 ~ UT-ALM-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | belongs_to :alert | E-04 L5 | ○ |
| C-62 | belongs_to :assignee | E-04 L6 | ○ |
| C-63 | alert presence | E-04 L8 | ○ |
| C-64 | assignee presence | E-04 L9 | ○ |
| C-65 | assignee uniqueness scope alert_id | E-04 L9 | ○ |

### MetricImageモデル (UT-ALM-066 ~ UT-ALM-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | belongs_to :alert | E-05 L9 | ○ |
| C-67 | uploads_sharding_key | E-05 L11-13 | ○ |
| C-68 | local_path | E-05 L17-24 | ○ |

### HttpIntegrations::CreateService (UT-ALM-069 ~ UT-ALM-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 正常作成 | E-06 L6-26 | ○ |
| C-70 | 権限エラー | E-06 L7, L30-32 | ○ |
| C-71 | 重複タイプエラー | E-06 L15-18, E-09 L21-27 | ○ |
| C-72 | バリデーションエラー | E-06 L21-22, E-09 L50-52 | ○ |

### HttpIntegrations::UpdateService (UT-ALM-073 ~ UT-ALM-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | 正常更新 | E-07 L15-33 | ○ |
| C-74 | 権限エラー | E-07 L16, L49-51 | ○ |
| C-75 | トークン再生成 | E-07 L39-43 | ○ |
| C-76 | タイプ変更重複エラー | E-07 L22-26, L45-47 | ○ |

### HttpIntegrations::DestroyService (UT-ALM-077 ~ UT-ALM-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | 正常削除 | E-08 L13-21 | ○ |
| C-78 | 権限エラー | E-08 L14, L39-41 | ○ |
| C-79 | 削除失敗 | E-08 L18-20 | ○ |

### Alerts::UpdateService (UT-ALM-080 ~ UT-ALM-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | 正常更新 | E-10 L19-35 | ○ |
| C-81 | 権限エラー | E-10 L21, L59-61 | ○ |
| C-82 | 空属性エラー | E-10 L76-77 | ○ |
| C-83 | 無効ステータスエラー | E-10 L116-127 | ○ |
| C-84 | assignees変更時システムノート | E-10 L102-113 | ○ |
| C-85 | assignee権限エラー | E-10 L89-100 | ○ |
| C-86 | ステータス変更時システムノート | E-10 L129-136 | ○ |
| C-87 | resolved時Todo解決 | E-10 L131, L138-140 | ○ |
| C-88 | 重複アラートエラー | E-10 L142-175 | ○ |

### Alerts::Todo::CreateService (UT-ALM-089 ~ UT-ALM-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | 正常作成 | E-11 L14-23 | ○ |
| C-90 | 権限エラー | E-11 L15, L40-42 | ○ |
| C-91 | 重複Todoエラー | E-11 L20-21, L44-46 | ○ |

### CreateAlertIssueService (UT-ALM-092 ~ UT-ALM-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | 正常作成 | E-12 L17-28 | ○ |
| C-93 | 権限エラー | E-12 L18, L71-73 | ○ |
| C-94 | Issue重複エラー | E-12 L19, L67-69 | ○ |
| C-95 | デフォルトタイトル更新 | E-12 L51-55 | ○ |
| C-96 | SystemNote作成 | E-12 L60 | ○ |

### ProcessPrometheusAlertService (UT-ALM-097 ~ UT-ALM-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | 正常処理 | E-13 L15-24 | ○ |
| C-98 | 必須属性エラー | E-13 L16 | ○ |
| C-99 | 永続化失敗エラー | E-13 L19 | ○ |

### MetricImages::UploadService (UT-ALM-100 ~ UT-ALM-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | 正常アップロード | E-14 L17-36 | ○ |
| C-101 | 権限エラー | E-14 L18-23 | ○ |
| C-102 | 保存失敗 | E-14 L34-35 | ○ |

### AlertsFinder (UT-ALM-103 ~ UT-ALM-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | 正常検索 | E-15 L17-28 | ○ |
| C-104 | 権限なしで空結果 | E-15 L18 | ○ |
| C-105 | statusフィルタ | E-15 L46-49 | ○ |
| C-106 | iidフィルタ | E-15 L40-44 | ○ |
| C-107 | assignee_usernameフィルタ | E-15 L60-62 | ○ |
| C-108 | searchフィルタ | E-15 L52-54 | ○ |
| C-109 | sort | E-15 L56-58 | ○ |
| C-110 | counts_by_status | E-15 L6-9 | ○ |

### HttpIntegrationsFinder (UT-ALM-111 ~ UT-ALM-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | 正常検索 | E-16 L12-21 | ○ |
| C-112 | endpoint_identifierフィルタ | E-16 L36-40 | ○ |
| C-113 | activeフィルタ | E-16 L42-46 | ○ |
| C-114 | type_identifierフィルタ | E-16 L48-56 | ○ |
| C-115 | filter_by_availability | E-16 L28-34 | ○ |

### AlertPresenter (UT-ALM-116 ~ UT-ALM-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | issue_description | E-17 L22-28 | ○ |
| C-117 | start_time | E-17 L30-32 | ○ |
| C-118 | details_url | E-17 L35-37 | ○ |
| C-119 | details | E-17 L39-41 | ○ |
| C-120 | email_title（環境あり） | E-17 L51-53 | ○ |
| C-121 | email_title（環境なし） | E-17 L51-53 | ○ |

### AlertProcessing Concern (UT-ALM-122 ~ UT-ALM-131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | process_alert（既存） | E-18 L21-23 | ○ |
| C-123 | process_alert（新規） | E-18 L21-23 | ○ |
| C-124 | process_resolved_alert | E-18 L35-43 | ○ |
| C-125 | Issue自動クローズ | E-18 L41-42, L49-53 | ○ |
| C-126 | process_firing_alert | E-18 L45-47 | ○ |
| C-127 | process_new_alert保存 | E-18 L55-73 | ○ |
| C-128 | 統合実行 | E-18 L59 | ○ |
| C-129 | fingerprint重複時再検索 | E-18 L61-63, L109-113 | ○ |
| C-130 | process_incident_issues | E-18 L75-79 | ○ |
| C-131 | send_alert_email | E-18 L81-85 | ○ |

### Responses Concern (UT-ALM-132 ~ UT-ALM-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | success | E-19 L6-8 | ○ |
| C-133 | bad_request | E-19 L14-16 | ○ |
| C-134 | unauthorized | E-19 L18-20 | ○ |
| C-135 | forbidden | E-19 L26-28 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースにソースコードの根拠が存在するため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全135件のテストケースにソースコードによる根拠が存在
- 既存のspecファイル（`spec/models/alert_management/`）との整合性確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションの境界値テストが適切か確認（TITLE_MAX_LENGTH=200, DESCRIPTION_MAX_LENGTH=1000など）
- [ ] 権限チェックのテストケースが全サービスクラスに含まれているか確認
- [ ] enum値の網羅性確認（severity: 6種類、domain: 2種類、type_identifier: 2種類）
- [ ] リレーションのinverse_of設定がテスト観点に反映されているか確認
- [ ] トランザクション処理のロールバックシナリオが含まれているか確認
- [ ] 既存のRSpecテスト（spec/models/alert_management/*_spec.rb）との重複・差分確認
