---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 134
  claims_with_evidence: 134
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：analytics.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：134 / 134、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/analytics/cycle_analytics.rb` - Analytics::CycleAnalyticsモジュール定義
- E-02: `app/models/analytics/usage_trends/measurement.rb` - Measurementモデル
- E-03: `app/models/analytics/cycle_analytics/stage.rb` - Stageモデル
- E-04: `app/models/analytics/cycle_analytics/merge_request_stage_event.rb` - MergeRequestStageEventモデル
- E-05: `app/models/analytics/cycle_analytics/issue_stage_event.rb` - IssueStageEventモデル
- E-06: `app/models/analytics/cycle_analytics/stage_aggregation.rb` - StageAggregationモデル
- E-07: `app/models/analytics/cycle_analytics/value_stream.rb` - ValueStreamモデル
- E-08: `app/models/analytics/cycle_analytics/aggregation.rb` - Aggregationモデル
- E-09: `app/models/analytics/cycle_analytics/stage_event_hash.rb` - StageEventHashモデル
- E-10: `app/models/analytics/cycle_analytics/project_level.rb` - ProjectLevelクラス
- E-11: `app/models/concerns/analytics/cycle_analytics/stageable.rb` - Stageableモジュール
- E-12: `app/models/concerns/analytics/cycle_analytics/parentable.rb` - Parentableモジュール
- E-13: `app/models/concerns/analytics/cycle_analytics/stage_event_model.rb` - StageEventModelモジュール

## 3) Claims と根拠の対応（レビューの主戦場）

### Analytics::CycleAnalytics (UT-ANL-001)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | table_name_prefixが'analytics_cycle_analytics_'を返す | E-01 L5-7 | ○ |

### Analytics::UsageTrends::Measurement (UT-ANL-002 - UT-ANL-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-02 | identifier enumがprojects(1)からbillable_users(11)まで定義 | E-02 L8-20 | ○ |
| C-03 | recorded_at, identifier, countが必須 | E-02 L22 | ○ |
| C-04 | recorded_atがidentifierスコープで一意 | E-02 L23 | ○ |
| C-05 | order_by_latestがrecorded_at降順でソート | E-02 L25 | ○ |
| C-06 | with_identifierが指定identifierでフィルタ | E-02 L26 | ○ |
| C-07 | recorded_afterが日付以降でフィルタ | E-02 L27 | ○ |
| C-08 | recorded_beforeが日付以前でフィルタ | E-02 L28 | ○ |
| C-09 | identifier_query_mappingが各識別子に対応するクエリを返す | E-02 L30-43 | ○ |
| C-10 | identifier_min_max_queriesがissues用カスタムクエリを持つ | E-02 L46-54 | ○ |
| C-11 | measurement_identifier_valuesが全値を返す | E-02 L56-58 | ○ |
| C-12 | find_latest_or_fallbackが最新レコードまたはフォールバックを返す | E-02 L60-62 | ○ |

### Analytics::CycleAnalytics::Stage (UT-ANL-015 - UT-ANL-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | MAX_STAGES_PER_VALUE_STREAMが15 | E-03 L6 | ○ |
| C-14 | nameがgroup_id, value_stream_idスコープで一意 | E-03 L13 | ○ |
| C-15 | max_stages_countバリデーションが機能 | E-03 L55-59 | ○ |
| C-16 | validate_default_stage_nameがデフォルトステージ名を検証 | E-03 L62-71 | ○ |
| C-17 | belongs_to value_streamリレーション | E-03 L17-18 | ○ |
| C-18 | has_one stage_aggregationリレーション | E-03 L19 | ○ |
| C-19 | parent alias for namespace | E-03 L21-22 | ○ |
| C-20 | to_global_idの動作 | E-03 L29-34 | ○ |
| C-21 | ensure_aggregation_record_presence!コールバック | E-03 L27, L73-75 | ○ |
| C-22 | distinct_stages_within_hierarchyクエリ | E-03 L36-51 | ○ |

### Analytics::CycleAnalytics::MergeRequestStageEvent (UT-ANL-029 - UT-ANL-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 必須フィールドバリデーション | E-04 L9 | ○ |
| C-24 | state enumがMergeRequest.available_statesを使用 | E-04 L11-12 | ○ |
| C-25 | belongs_to issuableリレーション | E-04 L14 | ○ |
| C-26 | assigned_toスコープ | E-04 L16-20 | ○ |
| C-27 | project_column, issuable_id_column, issuable_model, assignees_modelメソッド | E-04 L22-36 | ○ |

### Analytics::CycleAnalytics::IssueStageEvent (UT-ANL-037 - UT-ANL-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | 必須フィールドバリデーション | E-05 L9 | ○ |
| C-29 | state enumがIssue.available_statesを使用 | E-05 L11-12 | ○ |
| C-30 | belongs_to issuableリレーション | E-05 L13 | ○ |
| C-31 | assigned_toスコープ | E-05 L15-20 | ○ |
| C-32 | select_columns, column_list, insert_column_listがweight, sprint_idを含む | E-05 L35-57 | ○ |

### Analytics::CycleAnalytics::StageAggregation (UT-ANL-043 - UT-ANL-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | STATS_SIZE_LIMITが10 | E-06 L8 | ○ |
| C-34 | belongs_to stageが必須 | E-06 L10 | ○ |
| C-35 | 配列長バリデーション | E-06 L12-13 | ○ |
| C-36 | enabled, prioritized, incompleteスコープ | E-06 L15-17 | ○ |
| C-37 | load_batchメソッド | E-06 L19-21 | ○ |
| C-38 | cursor_for, set_cursorメソッド | E-06 L23-33 | ○ |
| C-39 | refresh_last_run, set_stats, completeメソッド | E-06 L35-47 | ○ |

### Analytics::CycleAnalytics::ValueStream (UT-ANL-057 - UT-ANL-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | MAX_VALUE_STREAMS_PER_NAMESPACEが50 | E-07 L6 | ○ |
| C-41 | has_many stagesリレーション | E-07 L12-16 | ○ |
| C-42 | name presence, length, uniquenessバリデーション | E-07 L18-19 | ○ |
| C-43 | max_value_streams_countバリデーション | E-07 L54-58 | ○ |
| C-44 | preload_associated_models, order_by_name_ascスコープ | E-07 L24-27 | ○ |
| C-45 | custom?メソッド | E-07 L31-33 | ○ |
| C-46 | build_default_value_streamファクトリメソッド | E-07 L35-37 | ○ |
| C-47 | projectヘルパーメソッド | E-07 L39-43 | ○ |
| C-48 | to_global_idメソッド | E-07 L45-50 | ○ |
| C-49 | ensure_aggregation_record_presenceコールバック | E-07 L29, L61-63 | ○ |

### Analytics::CycleAnalytics::Aggregation (UT-ANL-074 - UT-ANL-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | 配列長バリデーション | E-08 L7-13 | ○ |
| C-51 | priority_order, enabledスコープ | E-08 L15-17 | ○ |
| C-52 | cursor_for, consistency_check_cursor_forメソッド | E-08 L19-33 | ○ |
| C-53 | refresh_last_run, complete, set_cursor, set_statsメソッド | E-08 L35-55 | ○ |
| C-54 | estimated_next_run_atメソッド | E-08 L57-66 | ○ |
| C-55 | safe_create_for_namespaceファクトリメソッド | E-08 L68-88 | ○ |
| C-56 | load_batchクラスメソッド | E-08 L115-131 | ○ |

### Analytics::CycleAnalytics::StageEventHash (UT-ANL-092 - UT-ANL-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | hash_sha256必須バリデーション | E-09 L8 | ○ |
| C-58 | has_many cycle_analytics_stagesリレーション | E-09 L6 | ○ |
| C-59 | record_id_by_hash_sha256アトミック操作 | E-09 L11-35 | ○ |
| C-60 | cleanup_if_unusedメソッド | E-09 L38-41 | ○ |
| C-61 | unused_hashes_forメソッド | E-09 L44-48 | ○ |

### Analytics::CycleAnalytics::ProjectLevel (UT-ANL-100 - UT-ANL-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | initialize, summary, permissions, stats, []メソッド | E-10 L6-33 | ○ |

### Analytics::CycleAnalytics::Stageable (UT-ANL-105 - UT-ANL-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | start_event, end_eventメソッド | E-11 L40-48 | ○ |
| C-64 | events_hash_codeメソッド | E-11 L50-52 | ○ |
| C-65 | start_event_label_based?, end_event_label_based?メソッド | E-11 L54-60 | ○ |
| C-66 | default_stage?, subject_classメソッド | E-11 L80-87 | ○ |
| C-67 | validate_stage_event_pairsバリデーション | E-11 L91-97 | ○ |
| C-68 | validate_labelsバリデーション | E-11 L103-125 | ○ |
| C-69 | ensure_stage_event_hash_idコールバック | E-11 L127-135 | ○ |
| C-70 | cleanup_old_stage_event_hashコールバック | E-11 L137-141 | ○ |

### Analytics::CycleAnalytics::Parentable (UT-ANL-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | belongs_to namespaceリレーション | E-12 L9 | ○ |

### Analytics::CycleAnalytics::StageEventModel (UT-ANL-119 - UT-ANL-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | 各種スコープ定義 | E-13 L12-88 | ○ |
| C-73 | issuable_id, total_timeメソッド | E-13 L91-97 | ○ |
| C-74 | upsert_dataクラスメソッド | E-13 L100-118 | ○ |
| C-75 | keyset_order, arel_orderヘルパーメソッド | E-13 L120-129 | ○ |
| C-76 | select_columns, column_list, insert_column_listメソッド | E-13 L132-171 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルの重要なバリデーション（必須チェック、一意性制約）のテストケースが網羅されているか
- [ ] リレーション（belongs_to, has_many, has_one）のテストケースが存在するか
- [ ] スコープの動作確認テストケースが適切か
- [ ] 境界値テスト（配列の最大長、文字列長制限など）が含まれているか
- [ ] コールバック（before_save, after_create等）のテストケースが存在するか
- [ ] アトミック操作（upsert, ON CONFLICT）のテストケースが適切か
- [ ] 優先度の割り当てが適切か（金額計算、認証・認可は高優先度など）
