---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：anti_abuse 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全てのテストケースに根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/anti_abuse/event.rb` - AntiAbuse::Event モデル定義
- E-02: `app/models/anti_abuse/reports/individual_note_discussion.rb` - IndividualNoteDiscussion クラス定義
- E-03: `app/models/anti_abuse/reports/user_mention.rb` - UserMention モデル定義
- E-04: `app/workers/anti_abuse/ban_duplicate_users_worker.rb` - BanDuplicateUsersWorker ワーカー定義
- E-05: `app/workers/anti_abuse/spam_abuse_events_worker.rb` - SpamAbuseEventsWorker ワーカー定義
- E-06: `app/validators/anti_abuse/unique_detumbled_email_validator.rb` - UniqueDetumbledEmailValidator バリデータ定義
- E-07: `app/services/anti_abuse/abuse_report/create_service.rb` - CreateService サービス定義
- E-08: `app/finders/abuse_reports_finder.rb` - AbuseReportsFinder ファインダー定義
- E-09: `app/models/concerns/enums/abuse/category.rb` - Abuse カテゴリ Enum 定義
- E-10: `app/models/concerns/enums/abuse/source.rb` - Abuse ソース Enum 定義
- E-11: `app/models/abuse_report.rb` - AbuseReport モデル定義（関連モデル）

## 3) Claims と根拠の対応（レビューの主戦場）

### AntiAbuse::Event モデル (UT-AAB-001 〜 UT-AAB-017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | userリレーションが正しく取得できること | E-01 (L12: `belongs_to :user, inverse_of: :abuse_events`) | ○ |
| C-02 | abuse_reportリレーションが正しく取得できること | E-01 (L13: `belongs_to :abuse_report, class_name: '::AbuseReport'`) | ○ |
| C-03 | categoryが空の場合エラーとなること | E-01 (L7: `validates :category, presence: true`) | ○ |
| C-04 | sourceが空の場合エラーとなること | E-01 (L8: `validates :source, presence: true`) | ○ |
| C-05 | 作成時にuserが空の場合エラーとなること | E-01 (L9: `validates :user, presence: true, on: :create`) | ○ |
| C-06 | metadataが正しいJSON形式の場合バリデーションが通ること | E-01 (L10: `validates :metadata, json_schema: { filename: 'abuse_event_metadata' }`) | ○ |
| C-07 | metadataが不正なJSON形式の場合エラーとなること | E-01 (L10: json_schema バリデーション) | ○ |
| C-08 | metadataが空の場合バリデーションが通ること | E-01 (L10: `allow_blank: true`) | ○ |
| C-09 〜 C-12 | category enum 値の設定 | E-01 (L15), E-09 (categories: spam, virus, fraud, ci_cd) | ○ |
| C-13 〜 C-17 | source enum 値の設定 | E-01 (L16), E-10 (sources: spamcheck, virus_total, etc.) | ○ |

### AntiAbuse::Reports::IndividualNoteDiscussion (UT-AAB-018 〜 UT-AAB-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | individual_note? が常にtrueを返すこと | E-02 (L6-8: `def individual_note?; true; end`) | ○ |
| C-19 | can_convert_to_discussion? が常にtrueを返すこと | E-02 (L10-12: `def can_convert_to_discussion?; true; end`) | ○ |
| C-20 | convert_to_discussion! が正しく変換すること | E-02 (L14-16: `first_note.becomes!(Discussion.note_class).to_discussion`) | ○ |
| C-21 | first_noteが存在しない場合のエラー | E-02 (L15: first_note 呼び出し) | ○ |

### AntiAbuse::Reports::UserMention (UT-AAB-022 〜 UT-AAB-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | abuse_reportリレーションが正しく取得できること | E-03 (L8: `belongs_to :abuse_report, optional: false`) | ○ |
| C-23 | abuse_reportが空の場合エラーとなること | E-03 (L8: `optional: false`) | ○ |
| C-24 | noteリレーションが正しく取得できること | E-03 (L9: `belongs_to :note, optional: false`) | ○ |
| C-25 | noteが空の場合エラーとなること | E-03 (L9: `optional: false`) | ○ |
| C-26 | organizationリレーションが正しく取得できること | E-03 (L10: `belongs_to :organization`) | ○ |
| C-27 | organization_idが空の場合エラーとなること | E-03 (L12: `validates :organization_id, presence: true`) | ○ |

### AntiAbuse::BanDuplicateUsersWorker (UT-AAB-028 〜 UT-AAB-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | banned状態のユーザーの重複メールユーザーをbanできること | E-04 (L13-18, L24-35: perform, ban_users_with_the_same_detumbled_email!) | ○ |
| C-29 | banned_user_idが存在しない場合早期リターンすること | E-04 (L14-15: `return unless banned_user&.banned?`) | ○ |
| C-30 | ユーザーがbanned状態でない場合早期リターンすること | E-04 (L15: `banned_user&.banned?`) | ○ |
| C-31 | enforce_email_subaddress_restrictionsがtrueの場合処理が実行されること | E-04 (L25: `return unless ::Gitlab::CurrentSettings.enforce_email_subaddress_restrictions`) | ○ |
| C-32 | enforce_email_subaddress_restrictionsがfalseの場合早期リターンすること | E-04 (L25) | ○ |
| C-33 | ユーザーがbanされ属性が設定されログが出力されること | E-04 (L37-40: ban_user! メソッド) | ○ |
| C-34 | ロック取得中にユーザー状態が変わった場合banされないこと | E-04 (L30-33: `with_lock` と `if user.active?`) | ○ |
| C-35 | 正しい形式でログが出力されること | E-04 (L43-52: log_event メソッド) | ○ |

### AntiAbuse::SpamAbuseEventsWorker (UT-AAB-036 〜 UT-AAB-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | ユーザーが存在する場合report_userが呼ばれること | E-05 (L13-23: perform メソッド) | ○ |
| C-37 | ユーザーが存在しない場合早期リターンすること | E-05 (L17-20: `unless @user` 分岐) | ○ |
| C-38 | 既存のabuse_reportがない場合新規作成されること | E-05 (L39-45: `if abuse_report.nil?`) | ○ |
| C-39 | 既存のabuse_reportがある場合再利用されること | E-05 (L37-47: `AbuseReport.by_category...first`) | ○ |
| C-40 | CreateServiceが失敗した場合例外が発生すること | E-05 (L42: `raise ActiveRecord::RecordInvalid unless response.success?`) | ○ |
| C-41 | 正しいパラメータでAntiAbuse::Eventが作成されること | E-05 (L51-63: create_abuse_event メソッド) | ○ |
| C-42 | metadataに正しい情報が含まれること | E-05 (L55-60: metadata 構造) | ○ |

### AntiAbuse::UniqueDetumbledEmailValidator (UT-AAB-043 〜 UT-AAB-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | バリデーションが通る場合recordに変更がないこと | E-06 (L7-23: validate メソッド) | ○ |
| C-44 | 既にemailエラーがある場合早期リターンすること | E-06 (L8: `return if record.errors.include?(:email)`) | ○ |
| C-45 | enforce_email_subaddress_restrictionsがfalseの場合早期リターンすること | E-06 (L9: `return unless ::Gitlab::CurrentSettings.enforce_email_subaddress_restrictions`) | ○ |
| C-46 | bannedユーザーのメールを再利用しようとした場合エラーとなること | E-06 (L13-14: `prevent_banned_user_email_reuse?`) | ○ |
| C-47 | メール再利用制限に達した場合エラーとなること | E-06 (L15-16: `limit_normalized_email_reuse?`) | ○ |
| C-48 〜 C-49 | prevent_banned_user_email_reuse? の挙動 | E-06 (L27-29: `Users::BannedUser.by_detumbled_email(email).exists?`) | ○ |
| C-50 〜 C-53 | limit_normalized_email_reuse? の挙動と境界値 | E-06 (L5: `NORMALIZED_EMAIL_ACCOUNT_LIMIT = 5`, L31-33) | ○ |
| C-54 | 正しい形式でログが出力されること | E-06 (L35-40: log_failed_validation メソッド) | ○ |

### AntiAbuse::AbuseReport::CreateService (UT-AAB-055 〜 UT-AAB-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | paramsが正しく設定されること | E-07 (L8-10: initialize メソッド) | ○ |
| C-56 | 正常にAbuseReportが作成されること | E-07 (L12-17: execute メソッド) | ○ |
| C-57 | reporterがnilの場合エラーが返却されること | E-07 (L13: `return error('Reporter param must be a valid User') unless valid_reporter?`) | ○ |
| C-58 | reporterがUserでない場合エラーが返却されること | E-07 (L30-33: valid_reporter? メソッド) | ○ |
| C-59 | AbuseReport作成に失敗した場合エラーが返却されること | E-07 (L15: `return error('AbuseReport record was not created')`) | ○ |
| C-60 | organization_idがreporterから設定されること | E-07 (L23: `params[:organization_id] = params[:reporter].organization_id`) | ○ |
| C-61 〜 C-63 | valid_reporter? の挙動 | E-07 (L29-33) | ○ |

### AbuseReportsFinder (UT-AAB-064 〜 UT-AAB-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | 全フィルターが適用されたレポート一覧が返却されること | E-08 (L19-25: execute メソッド) | ○ |
| C-65 〜 C-67 | filter_by_status の挙動 | E-08 (L36-45: filter_by_status メソッド) | ○ |
| C-68 | categoryでフィルターされること | E-08 (L47-51: filter_by_category メソッド) | ○ |
| C-69 〜 C-70 | filter_by_user の挙動 | E-08 (L53-60: filter_by_user メソッド) | ○ |
| C-71 | reporterでフィルターされること | E-08 (L62-69: filter_by_reporter メソッド) | ○ |
| C-72 〜 C-73 | sort_reports の挙動 | E-08 (L80-85: sort_reports メソッド) | ○ |
| C-74 〜 C-75 | aggregate_reports の挙動 | E-08 (L91-98: aggregate_reports メソッド) | ○ |

### Enums::Abuse (UT-AAB-076 〜 UT-AAB-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | 全カテゴリが正しく定義されていること | E-09 (L6-12: categories メソッド) | ○ |
| C-77 | 全ソースが正しく定義されていること | E-10 (L6-14: sources メソッド) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接確認可能でした

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースに明確な根拠があり、ソースコードとの整合性が確認できました
- 注意点:
  - BanDuplicateUsersWorker: ユーザーban処理は重要なセキュリティ機能のため、実際のテスト実行時に慎重なレビューを推奨
  - UniqueDetumbledEmailValidator: NORMALIZED_EMAIL_ACCOUNT_LIMIT=5 の境界値テストは正確に実装すること
  - SpamAbuseEventsWorker: 外部サービス(spamcheck)との連携部分は統合テストも検討

## 6) レビュアーチェックリスト（最小）
- [ ] AntiAbuse::Event の enum 値（category, source）が Enums::Abuse モジュールの定義と一致していることを確認
- [ ] BanDuplicateUsersWorker の with_lock 処理が競合状態を正しく処理することを確認
- [ ] UniqueDetumbledEmailValidator の NORMALIZED_EMAIL_ACCOUNT_LIMIT 境界値テストが正確であることを確認
- [ ] SpamAbuseEventsWorker の CreateService 失敗時の例外処理が適切であることを確認
- [ ] AbuseReportsFinder の集計処理（aggregated_by_user_and_category）が期待通り動作することを確認
- [ ] IndividualNoteDiscussion の convert_to_discussion! が親クラス Discussion との整合性を保っていることを確認
