---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 46
  claims_with_evidence: 46
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：app_config単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：46 / 46、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/app_config/instance_metadata.rb` - InstanceMetadataモデル定義
- E-02: `app/models/app_config/kas_metadata.rb` - KasMetadataモデル定義
- E-03: `app/policies/app_config/instance_metadata_policy.rb` - InstanceMetadataポリシー定義
- E-04: `app/graphql/types/app_config/kas_type.rb` - KasType GraphQL型定義
- E-05: `app/graphql/types/app_config/instance_metadata_type.rb` - InstanceMetadataType GraphQL型定義
- E-06: `app/graphql/types/app_config/gitlab_instance_feature_flag_type.rb` - GitlabInstanceFeatureFlagType定義
- E-07: `app/graphql/resolvers/app_config/instance_metadata_resolver.rb` - InstanceMetadataリゾルバ定義
- E-08: `app/graphql/resolvers/app_config/gitlab_instance_feature_flags_resolver.rb` - GitlabInstanceFeatureFlagsリゾルバ定義
- E-09: `spec/models/app_config/instance_metadata_spec.rb` - 既存の単体テスト仕様
- E-10: `spec/models/app_config/kas_metadata_spec.rb` - 既存のKasMetadataテスト仕様
- E-11: `spec/policies/app_config/instance_metadata_policy_spec.rb` - 既存のポリシーテスト仕様
- E-12: `spec/graphql/resolvers/app_config/instance_metadata_resolver_spec.rb` - 既存のリゾルバテスト仕様
- E-13: `lib/gitlab/kas.rb` - Gitlab::Kasモジュール定義
- E-14: `lib/gitlab/kas/server_info.rb` - ServerInfoクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstanceMetadata.initializeのデフォルト値テスト | E-01, E-09 | ○ |
| C-02 | InstanceMetadata.initializeのカスタム値テスト | E-01 | ○ |
| C-03 | InstanceMetadata.versionアクセサテスト | E-01, E-09 | ○ |
| C-04 | InstanceMetadata.revisionアクセサテスト | E-01, E-09 | ○ |
| C-05 | InstanceMetadata.kasアクセサテスト | E-01, E-09 | ○ |
| C-06 | InstanceMetadata.enterpriseアクセサテスト | E-01, E-09 | ○ |
| C-07 | KasMetadata.initialize（KAS有効時）テスト | E-02, E-10 | ○ |
| C-08 | KasMetadata.initialize（KAS無効時）テスト | E-02, E-10 | ○ |
| C-09 | KasMetadata.declarative_policy_classテスト | E-02, E-10 | ○ |
| C-10 | KasMetadata.enabled（KAS有効時）テスト | E-02, E-10 | ○ |
| C-11 | KasMetadata.enabled（KAS無効時）テスト | E-02, E-10 | ○ |
| C-12 | KasMetadata.version（KAS有効時）テスト | E-02, E-10, E-14 | ○ |
| C-13 | KasMetadata.version（KAS無効時）テスト | E-02, E-10 | ○ |
| C-14 | KasMetadata.external_url（KAS有効時）テスト | E-02, E-10, E-13 | ○ |
| C-15 | KasMetadata.external_url（KAS無効時）テスト | E-02, E-10 | ○ |
| C-16 | KasMetadata.external_k8s_proxy_url（KAS有効時）テスト | E-02, E-10, E-13 | ○ |
| C-17 | KasMetadata.external_k8s_proxy_url（KAS無効時）テスト | E-02, E-10 | ○ |
| C-18 | InstanceMetadataPolicy.delegate委譲テスト | E-03 | ○ |
| C-19 | InstanceMetadataPolicy（ログインユーザー）認可テスト | E-03, E-11 | ○ |
| C-20 | InstanceMetadataPolicy（匿名ユーザー）認可テスト | E-03, E-11 | ○ |
| C-21 | InstanceMetadataResolver.resolveテスト | E-07, E-12 | ○ |
| C-22 | InstanceMetadataResolver version含有テスト | E-07, E-12 | ○ |
| C-23 | InstanceMetadataResolver revision含有テスト | E-07, E-12 | ○ |
| C-24 | InstanceMetadataResolver kas含有テスト | E-07, E-12 | ○ |
| C-25 | GitlabInstanceFeatureFlagsResolver 正常系テスト | E-08 | ○ |
| C-26 | GitlabInstanceFeatureFlagsResolver 空配列テスト | E-08 | ○ |
| C-27 | GitlabInstanceFeatureFlagsResolver 複数フラグテスト | E-08 | ○ |
| C-28 | GitlabInstanceFeatureFlagsResolver 未定義フラグ除外テスト | E-08 | ○ |
| C-29 | GitlabInstanceFeatureFlagsResolver 最大件数テスト | E-08 | ○ |
| C-30 | GitlabInstanceFeatureFlagsResolver 最大件数超過テスト | E-08 | ○ |
| C-31 | GitlabInstanceFeatureFlagsResolver ユーザー別有効フラグテスト | E-08 | ○ |
| C-32 | GitlabInstanceFeatureFlagsResolver ユーザー別無効フラグテスト | E-08 | ○ |
| C-33 | InstanceMetadataType authorize設定テスト | E-05 | ○ |
| C-34 | InstanceMetadataType versionフィールドテスト | E-05 | ○ |
| C-35 | InstanceMetadataType revisionフィールドテスト | E-05 | ○ |
| C-36 | InstanceMetadataType enterpriseフィールドテスト | E-05 | ○ |
| C-37 | InstanceMetadataType kasフィールドテスト | E-05 | ○ |
| C-38 | InstanceMetadataType feature_flagsフィールドテスト | E-05 | ○ |
| C-39 | KasType authorize設定テスト | E-04 | ○ |
| C-40 | KasType enabledフィールドテスト | E-04 | ○ |
| C-41 | KasType versionフィールドテスト | E-04 | ○ |
| C-42 | KasType external_urlフィールドテスト | E-04 | ○ |
| C-43 | KasType external_k8s_proxy_urlフィールドテスト | E-04 | ○ |
| C-44 | GitlabInstanceFeatureFlagType authorize設定テスト | E-06 | ○ |
| C-45 | GitlabInstanceFeatureFlagType nameフィールドテスト | E-06 | ○ |
| C-46 | GitlabInstanceFeatureFlagType enabledフィールドテスト | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全テストケースがソースコードおよび既存テストファイルに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠があり、既存テストと整合性が取れています
- 注意点：
  - GitlabInstanceFeatureFlagsResolverのテストケース（C-25〜C-32）は既存テストファイルが確認できなかったため、ソースコードのみを根拠としています
  - 実際のテスト実装時には、Feature::Definitionのモック設定が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] InstanceMetadataの初期化テストがデフォルト値とカスタム値の両方をカバーしているか
- [ ] KasMetadataがKAS有効/無効の両状態をテストしているか
- [ ] InstanceMetadataPolicyがログインユーザーと匿名ユーザーの両方を検証しているか
- [ ] GitlabInstanceFeatureFlagsResolverの最大件数（20件）制限がテストされているか
- [ ] 全GraphQL型のauthorize設定がテストに含まれているか
- [ ] 既存テストファイル（spec/models/app_config/*, spec/policies/app_config/*）との整合性を確認
