---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 130
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：application_setting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の対応するメソッド・バリデーション・ロジックが存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なメソッド・バリデーションを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：130 / 130、根拠なし：0
- 優先レビュー（高）
  1. **UT-APS-001〜009**: ApplicationSetting::Termモデルのテストケース - latestメソッド、accepted_by_user?メソッド、バリデーション
  2. **UT-APS-046〜047**: 相互排他バリデーション（object_storage、snowplow）
  3. **UT-APS-096〜097**: runners_registration_tokenの認証関連テスト

## 2) 参照した情報（Evidence一覧）
> 実在するソースコードファイルを列挙

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/application_setting/term.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/application_setting.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/application_setting_implementation.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/policies/application_setting/term_policy.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### ApplicationSetting::Term モデル（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-APS-001: latestメソッドがorder(:id).lastで最新を取得 | E-01 L13-15 `def self.latest; order(:id).last; end` | ○ |
| C-02 | UT-APS-002: Termレコードが存在しない場合にnilが返る | E-01 L14 `.last`の動作 | ○ |
| C-03 | UT-APS-003: project_botユーザーの場合はtrueが返る | E-01 L18 `return true if user.project_bot?` | ○ |
| C-04 | UT-APS-004: accepted_term_idが一致する場合はtrueが返る | E-01 L20 `user.accepted_term_id == id` | ○ |
| C-05 | UT-APS-005: term_agreementsにacceptedレコードがある場合はtrueが返る | E-01 L21 `term_agreements.accepted.where(user: user).exists?` | ○ |
| C-06 | UT-APS-006: 規約に未同意の場合はfalseが返る | E-01 L17-22 条件の否定 | ○ |
| C-07 | UT-APS-007: has_many :term_agreementsが定義されている | E-01 L7 `has_many :term_agreements` | ○ |
| C-08 | UT-APS-008: termsのpresenceバリデーション | E-01 L11 `validates :terms, presence: true` | ○ |
| C-09 | UT-APS-009: cache_markdown_field :terms | E-01 L9 `cache_markdown_field :terms` | ○ |

### ApplicationSetting モデル メソッド（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | UT-APS-010: push_rule - Feature有効時にnilが返る | E-02 L1305-1311 `def push_rule; if Feature.enabled?...nil...end` | ○ |
| C-11 | UT-APS-011: push_rule - Feature無効時にsuperが返る | E-02 L1309 `super` | ○ |
| C-12 | UT-APS-012: validate_grafana_url | E-02 L1123-1125 `def validate_grafana_url` | ○ |
| C-13 | UT-APS-013: validate_kroki_url | E-02 L1131-1133 `def validate_kroki_url` | ○ |
| C-14 | UT-APS-014: grafana_url_absolute? | E-02 L1127-1129 `def grafana_url_absolute?; parsed_grafana_url&.absolute?; end` | ○ |
| C-15 | UT-APS-015: 相対URLの場合にfalseが返る | E-02 L1128 `&.absolute?`の動作 | ○ |
| C-16 | UT-APS-016: sourcegraph_url_is_com? - sourcegraph.com | E-02 L1135-1137 正規表現マッチ | ○ |
| C-17 | UT-APS-017: sourcegraph_url_is_com? - www.sourcegraph.com | E-02 L1136 `(www\.)?sourcegraph\.com` | ○ |
| C-18 | UT-APS-018: sourcegraph_url_is_com? - 他のドメイン | E-02 L1136 正規表現不一致 | ○ |
| C-19 | UT-APS-019: normalize_default_branch_name - 空文字列がnilに | E-02 L1139-1141 `default_branch_name.presence` | ○ |
| C-20 | UT-APS-020: normalize_default_branch_name - 有効な値は保持 | E-02 L1140 `presence`の動作 | ○ |
| C-21 | UT-APS-021: default_branch_protected? - 保護設定あり | E-02 L1143-1145 `Gitlab::Access::DefaultBranchProtection.new(...).any?` | ○ |
| C-22 | UT-APS-022: default_branch_protected? - 保護設定なし | E-02 L1144 `.any?`がfalseを返す | ○ |
| C-23 | UT-APS-023: instance_review_permitted? - 50ユーザー以上 | E-02 L1147-1153 `users_count >= INSTANCE_REVIEW_MIN_USERS` | ○ |
| C-24 | UT-APS-024: instance_review_permitted? - 50ユーザー未満 | E-02 L1152 比較がfalse | ○ |
| C-25 | UT-APS-025: create_from_defaults - 新規作成 | E-02 L1157-1176 `def self.create_from_defaults` | ○ |
| C-26 | UT-APS-026: create_from_defaults - Recursionエラー | E-02 L1162 `raise Recursion` | ○ |
| C-27 | UT-APS-027: create_from_defaults - RecordNotUnique時 | E-02 L1171-1173 `rescue ActiveRecord::RecordNotUnique` | ○ |
| C-28 | UT-APS-028: check_schema! - 主キーなし | E-02 L1192-1196 `raise "The..."` | ○ |
| C-29 | UT-APS-029: cache_backend | E-02 L1202-1204 `Gitlab::ProcessMemoryCache.cache_backend` | ○ |
| C-30 | UT-APS-030: human_attribute_name | E-02 L1206-1208 `HUMANIZED_ATTRIBUTES[attribute.to_sym]` | ○ |
| C-31 | UT-APS-031: recaptcha_or_login_protection_enabled - recaptcha_enabled | E-02 L1257-1259 `recaptcha_enabled \|\| login_recaptcha_protection_enabled` | ○ |
| C-32 | UT-APS-032: recaptcha_or_login_protection_enabled - login_recaptcha | E-02 L1258 OR条件 | ○ |
| C-33 | UT-APS-033: recaptcha_or_login_protection_enabled - 両方false | E-02 L1258 両方falseでfalse | ○ |
| C-34 | UT-APS-034: kroki_format_supported? - excalidraw | E-02 L1267-1280 case文 | ○ |
| C-35 | UT-APS-035: kroki_format_supported? - bpmn | E-02 L1272 `return kroki_formats_bpmn` | ○ |
| C-36 | UT-APS-036: kroki_format_supported? - mermaid | E-02 L1274 `return kroki_formats_mermaid` | ○ |
| C-37 | UT-APS-037: kroki_format_supported? - blockdiag | E-02 L1277 `BLOCKDIAG_FORMATS.include?` | ○ |
| C-38 | UT-APS-038: kroki_format_supported? - デフォルト形式 | E-02 L1279 `SUPPORTED_DIAGRAM_NAMES.include?` | ○ |
| C-39 | UT-APS-039: personal_access_tokens_disabled? | E-02 L1282-1284 `false` | ○ |
| C-40 | UT-APS-040: ci_delete_pipelines_in_seconds_limit_human_readable_long | E-02 L1294-1297 `ChronicDuration.output` | ○ |
| C-41 | UT-APS-041: ci_delete_pipelines_in_seconds_limit_human_readable_long - nil | E-02 L1296 `if value` | ○ |
| C-42 | UT-APS-042: allow_user_remember_me? - 正常 | E-02 L1299-1303 `remember_me_enabled?` | ○ |
| C-43 | UT-APS-043: allow_user_remember_me? - session_expire_from_init | E-02 L1300 `return false if session_expire_from_init?` | ○ |
| C-44 | UT-APS-044: custom_default_search_scope_set? - 有効なスコープ | E-02 L1313-1315 `all_scope_names.include?` | ○ |
| C-45 | UT-APS-045: custom_default_search_scope_set? - system default | E-02 L1314 `SEARCH_SCOPE_SYSTEM_DEFAULT`は含まれない | ○ |
| C-46 | UT-APS-046: validate_object_storage_for_live_trace_configuration | E-02 L1116-1121 バリデーションメソッド | ○ |
| C-47 | UT-APS-047: snowplow_and_product_usage_data_are_mutually_exclusive | E-02 L1336-1343 相互排他バリデーション | ○ |

### ApplicationSetting バリデーション（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | UT-APS-048: validates :uuid, presence: true | E-02 L135 | ○ |
| C-49 | UT-APS-049: validates :minimum_password_length - 最小値 | E-02 L142-148 `greater_than_or_equal_to: DEFAULT_MINIMUM_PASSWORD_LENGTH` | ○ |
| C-50 | UT-APS-050: validates :minimum_password_length - 最大値 | E-02 L147 `less_than_or_equal_to: Devise.password_length.max` | ○ |
| C-51 | UT-APS-051: validates :two_factor_grace_period | E-02 L173-174 `greater_than_or_equal_to: 0` | ○ |
| C-52 | UT-APS-052: validates :deletion_adjourned_period - 0以下 | E-02 L439-441 `greater_than: 0` | ○ |
| C-53 | UT-APS-053: validates :deletion_adjourned_period - 90超過 | E-02 L441 `less_than_or_equal_to: 90` | ○ |
| C-54 | UT-APS-054: validates :hashed_storage_enabled | E-02 L395-396 `inclusion: { in: [true] }` | ○ |
| C-55 | UT-APS-055: validates :deactivate_dormant_users_period | E-02 L413-417 `greater_than_or_equal_to: 90` | ○ |
| C-56 | UT-APS-056: validates :default_preferred_language | E-02 L328 `inclusion: { in: Gitlab::I18n.available_locales }` | ○ |
| C-57 | UT-APS-057: validates :archive_builds_in_seconds | E-02 L348-354 `greater_than_or_equal_to: 1.day.seconds` | ○ |
| C-58 | UT-APS-058: validates :protected_paths | E-02 L378-380 `maximum: 100` | ○ |
| C-59 | UT-APS-059: validates :wiki_page_max_content_bytes | E-02 L390 `greater_than_or_equal_to: 1.kilobyte` | ○ |
| C-60 | UT-APS-060: validates :sentry_clientside_traces_sample_rate - 0未満 | E-02 L886-889 `greater_than_or_equal_to: 0` | ○ |
| C-61 | UT-APS-061: validates :sentry_clientside_traces_sample_rate - 1超過 | E-02 L888 `less_than_or_equal_to: 1` | ○ |
| C-62 | UT-APS-062: enum :whats_new_variant | E-02 L46 `all_tiers: 0` | ○ |
| C-63 | UT-APS-063: enum :email_confirmation_setting | E-02 L47 `off: 0` | ○ |

### ApplicationSetting::TermPolicy（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | UT-APS-064: condition :current_terms | E-04 L7-9 `latest_terms == @subject` | ○ |
| C-65 | UT-APS-065: condition :terms_accepted | E-04 L11-13 `agreement&.accepted` | ○ |
| C-66 | UT-APS-066: rule current_terms | E-04 L15-18 `enable :accept_terms; enable :decline_terms` | ○ |
| C-67 | UT-APS-067: rule terms_accepted | E-04 L20 `prevent :accept_terms` | ○ |
| C-68 | UT-APS-068: agreement - 正常 | E-04 L23-29 `find_by(term: @subject)` | ○ |
| C-69 | UT-APS-069: agreement - userがnil | E-04 L25 `next nil if @user.nil?` | ○ |
| C-70 | UT-APS-070: agreement - subjectがnil | E-04 L25 `@subject.nil?` | ○ |

### ApplicationSettingImplementation（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | UT-APS-071: defaults | E-03 L37-373 `def defaults` | ○ |
| C-72 | UT-APS-072: default_commit_email_hostname | E-03 L379-381 `users.noreply.#{Gitlab.config.gitlab.host}` | ○ |
| C-73 | UT-APS-073: default_min_key_size - FIPS無効 | E-03 L389-395 `else 0` | ○ |
| C-74 | UT-APS-074: default_min_key_size - FIPS有効 | E-03 L390-391 `supported_sizes...min` | ○ |
| C-75 | UT-APS-075: domain_allowlist_raw | E-03 L423-425 `array_to_string` | ○ |
| C-76 | UT-APS-076: domain_allowlist_raw= | E-03 L431-433 `strings_to_array` | ○ |
| C-77 | UT-APS-077: domain_denylist_raw | E-03 L427-429 `array_to_string` | ○ |
| C-78 | UT-APS-078: domain_denylist_file= | E-03 L439-441 `file.read` | ○ |
| C-79 | UT-APS-079: outbound_local_requests_allowlist_arrays | E-03 L466-474 `separate_allowlists` | ○ |
| C-80 | UT-APS-080: outbound_local_requests_allowlist_arrays - 空 | E-03 L468 `next [[], []]` | ○ |
| C-81 | UT-APS-081: parse_addr_and_port - IPv6 | E-03 L754-756 正規表現マッチ | ○ |
| C-82 | UT-APS-082: parse_addr_and_port - IPv4 | E-03 L758-760 正規表現マッチ | ○ |
| C-83 | UT-APS-083: parse_addr_and_port - ポートなし | E-03 L761-763 `else` | ○ |
| C-84 | UT-APS-084: coerce_iframe_rendering_allowlist | E-03 L516-524 `.sub`でプレフィックス除去 | ○ |
| C-85 | UT-APS-085: asset_proxy_whitelist= | E-03 L534-541 `Gitlab.config.gitlab.host`追加 | ○ |
| C-86 | UT-APS-086: commit_email_hostname - 設定あり | E-03 L548-550 `super.presence` | ○ |
| C-87 | UT-APS-087: commit_email_hostname - 空 | E-03 L549 `\|\| self.class.default_commit_email_hostname` | ○ |
| C-88 | UT-APS-088: default_project_visibility= | E-03 L552-554 `Gitlab::VisibilityLevel.level_value` | ○ |
| C-89 | UT-APS-089: restricted_visibility_levels= | E-03 L564-566 `level_value`変換 | ○ |
| C-90 | UT-APS-090: performance_bar_allowed_group | E-03 L576-578 `Group.find_by_id` | ○ |
| C-91 | UT-APS-091: performance_bar_allowed_group - nil | E-03 L577 `find_by_id`がnil返却 | ○ |
| C-92 | UT-APS-092: performance_bar_enabled | E-03 L581-583 `performance_bar_allowed_group_id.present?` | ○ |
| C-93 | UT-APS-093: normalized_repository_storage_weights | E-03 L585-596 重み正規化ロジック | ○ |
| C-94 | UT-APS-094: normalized_repository_storage_weights - 合計0 | E-03 L591 `next w if weights_total == 0` | ○ |
| C-95 | UT-APS-095: pick_repository_storage | E-03 L599-601 `max_by`で選択 | ○ |
| C-96 | UT-APS-096: runners_registration_token - 許可 | E-03 L603-607 `ensure_runners_registration_token!` | ○ |
| C-97 | UT-APS-097: runners_registration_token - 不許可 | E-03 L604 `return unless Gitlab::CurrentSettings.allow_runner_registration_token` | ○ |
| C-98 | UT-APS-098: usage_ping_can_be_configured? | E-03 L617-619 `Settings.gitlab.usage_ping_enabled` | ○ |
| C-99 | UT-APS-099: usage_ping_enabled | E-03 L633-636 `usage_ping_can_be_configured? && super` | ○ |
| C-100 | UT-APS-100: allowed_key_types | E-03 L645-649 フィルタリング | ○ |
| C-101 | UT-APS-101: allowed_key_types - 禁止 | E-03 L647 `!= FORBIDDEN_KEY_VALUE` | ○ |
| C-102 | UT-APS-102: key_restriction_for | E-03 L651-655 `public_send(attr_name)` | ○ |
| C-103 | UT-APS-103: key_restriction_for - 存在しない | E-03 L654 `FORBIDDEN_KEY_VALUE` | ○ |
| C-104 | UT-APS-104: allow_signup? | E-03 L657-659 `signup_enabled? && password_authentication_enabled_for_web?` | ○ |
| C-105 | UT-APS-105: allow_signup? - 無効 | E-03 L658 AND条件 | ○ |
| C-106 | UT-APS-106: password_authentication_enabled? - Web | E-03 L661-663 `password_authentication_enabled_for_web?` | ○ |
| C-107 | UT-APS-107: password_authentication_enabled? - Git | E-03 L662 OR条件 | ○ |
| C-108 | UT-APS-108: user_default_internal_regex_enabled? | E-03 L665-667 `user_default_external? && user_default_internal_regex.present?` | ○ |
| C-109 | UT-APS-109: user_default_internal_regex_instance | E-03 L669-671 `Regexp.new(..., Regexp::IGNORECASE)` | ○ |
| C-110 | UT-APS-110: latest_terms | E-03 L674-676 `ApplicationSetting::Term.latest` | ○ |
| C-111 | UT-APS-111: reset_memoized_terms | E-03 L678-681 `@latest_terms = nil` | ○ |
| C-112 | UT-APS-112: archive_builds_older_than | E-03 L683-685 `archive_builds_in_seconds.seconds.ago` | ○ |
| C-113 | UT-APS-113: archive_builds_older_than - nil | E-03 L684 `if archive_builds_in_seconds` | ○ |
| C-114 | UT-APS-114: static_objects_external_storage_enabled? | E-03 L687-689 `url.present?` | ○ |
| C-115 | UT-APS-115: static_objects_external_storage_enabled? - 未設定 | E-03 L688 `present?`がfalse | ○ |
| C-116 | UT-APS-116: ensure_key_restrictions! | E-03 L691-698 FIPSモードでの制限設定 | ○ |
| C-117 | UT-APS-117: ensure_key_restrictions! - read_only | E-03 L692 `return if Gitlab::Database.read_only?` | ○ |
| C-118 | UT-APS-118: repository_storages_with_default_weight | E-03 L700-708 ストレージ設定 | ○ |
| C-119 | UT-APS-119: allow_immediate_namespaces_deletion_for_user? - admin | E-03 L710-715 `user&.can_admin_all_resources?` | ○ |
| C-120 | UT-APS-120: allow_immediate_namespaces_deletion_for_user? - 設定有効 | E-03 L714 `allow_immediate_namespaces_deletion?` | ○ |
| C-121 | UT-APS-121: check_repository_storages_weighted - 無効ストレージ | E-03 L793-796 `invalid.empty?`チェック | ○ |
| C-122 | UT-APS-122: check_repository_storages_weighted - 範囲外 | E-03 L805-806 `val.between?(0, 100)` | ○ |
| C-123 | UT-APS-123: check_valid_runner_registrars | E-03 L811-815 `valid_runner_registrar_combinations.include?` | ○ |
| C-124 | UT-APS-124: terms_exist | E-03 L823-827 `unless terms.present?` | ○ |

### ApplicationSetting コールバック・その他（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | UT-APS-125: ensure_uuid! - 自動生成 | E-03 L783-787 `self.uuid = SecureRandom.uuid` | ○ |
| C-126 | UT-APS-126: ensure_uuid! - 既存 | E-03 L784 `return if uuid?` | ○ |
| C-127 | UT-APS-127: coerce_repository_storages_weighted | E-03 L789-791 `transform_values!(&:to_i)` | ○ |
| C-128 | UT-APS-128: after_commit reset_deletion_warning_redis_key | E-02 L1114 `reset_deletion_warning_redis_key` | ○ |
| C-129 | UT-APS-129: after_commit expire_performance_bar_allowed_user_ids_cache | E-02 L1111-1113 `expire_performance_bar_allowed_user_ids_cache` | ○ |
| C-130 | UT-APS-130: validates :restricted_visibility_levels | E-02 L443-449 `validates_each` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースはソースコード上のメソッド・バリデーション・ロジックに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースはソースコードに明確な根拠があります
- 注意点:
  - 暗号化属性（attr_encrypted）のテストは単体テストでは限定的になる可能性があります
  - Featureフラグに依存するメソッドは実行時の状態によって動作が変わります
  - EE機能との統合部分は別途確認が必要な場合があります

## 6) レビュアーチェックリスト（最小）
- [ ] ApplicationSetting::Termモデルのテストケース（UT-APS-001〜009）が利用規約機能の要件を満たしているか
- [ ] バリデーションテストケース（UT-APS-048〜063）がセキュリティ要件を満たしているか
- [ ] 認証関連テストケース（UT-APS-042, 096, 097, 104〜107）が認証フローの要件を満たしているか
- [ ] FIPSモード関連テストケース（UT-APS-073, 074, 116, 117）がコンプライアンス要件を満たしているか
- [ ] ポリシーテストケース（UT-APS-064〜070）が権限管理の要件を満たしているか
