---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 137
  claims_with_evidence: 137
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：atlassian.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（atlassian.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：137 / 137、根拠なし：0
- 優先レビュー（高）
  1. **セキュリティ関連（トークン暗号化）**：attr_encryptedの動作確認が重要
  2. **JWT検証ロジック**：認証・認可に関わる重要機能
  3. **Jiraキー抽出ロジック**：コア機能の正確性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/atlassian/identity.rb` - Atlassian Identityモデル
- E-02: `lib/gitlab/auth/atlassian/auth_hash.rb` - OAuth認証ハッシュ処理
- E-03: `lib/gitlab/auth/atlassian/identity_linker.rb` - Identity連携処理
- E-04: `lib/gitlab/auth/atlassian/token_refresher.rb` - トークンリフレッシュ処理
- E-05: `lib/gitlab/auth/atlassian/user.rb` - Atlassianユーザー処理
- E-06: `lib/atlassian/jira_connect.rb` - JiraConnect基本設定
- E-07: `lib/atlassian/jira_issue_key_extractor.rb` - Jiraキー抽出
- E-08: `lib/atlassian/jira_connect/client.rb` - Jira APIクライアント
- E-09: `lib/atlassian/jira_connect/jwt_validator.rb` - JWTバリデーション
- E-10: `lib/atlassian/jira_connect/jwt/symmetric.rb` - 対称JWT処理
- E-11: `lib/atlassian/jira_connect/jwt/asymmetric.rb` - 非対称JWT処理
- E-12: `lib/atlassian/jira_connect/jira_user.rb` - Jiraユーザー情報
- E-13: `lib/atlassian/jira_issue_key_extractors/branch.rb` - ブランチからのキー抽出
- E-14: `lib/atlassian/jira_connect/serializers/base_entity.rb` - ベースエンティティ
- E-15: `lib/atlassian/jira_connect/serializers/branch_entity.rb` - ブランチシリアライザ
- E-16: `lib/atlassian/jira_connect/serializers/build_entity.rb` - ビルドシリアライザ
- E-17: `lib/atlassian/jira_connect/serializers/deployment_entity.rb` - デプロイメントシリアライザ
- E-18: `lib/atlassian/jira_connect/serializers/feature_flag_entity.rb` - フィーチャーフラグシリアライザ
- E-19: `lib/atlassian/jira_connect/serializers/pull_request_entity.rb` - PRシリアライザ
- E-20: `lib/atlassian/jira_connect/serializers/repository_entity.rb` - リポジトリシリアライザ
- E-21: `lib/atlassian/jira_connect/serializers/commit_entity.rb` - コミットシリアライザ
- E-22: `lib/atlassian/jira_connect/serializers/environment_entity.rb` - 環境シリアライザ
- E-23: `lib/atlassian/jira_connect/serializers/reviewer_entity.rb` - レビュアーシリアライザ
- E-24: `lib/atlassian/jira_connect/serializers/file_entity.rb` - ファイルシリアライザ
- E-25: `lib/atlassian/jira_connect/serializers/pipeline_entity.rb` - パイプラインシリアライザ
- E-26: `lib/atlassian/jira_connect/serializers/author_entity.rb` - 著者シリアライザ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Atlassian::Identity belongs_to :user リレーション | E-01 (L9) | ○ |
| C-02 | extern_uid presence/uniquenessバリデーション | E-01 (L11) | ○ |
| C-03 | user presence/uniquenessバリデーション | E-01 (L12) | ○ |
| C-04 | token attr_encrypted設定 | E-01 (L14-18) | ○ |
| C-05 | refresh_token attr_encrypted設定 | E-01 (L20-26) | ○ |
| C-06 | AuthHash#token メソッド | E-02 (L7-9) | ○ |
| C-07 | AuthHash#refresh_token メソッド | E-02 (L11-13) | ○ |
| C-08 | AuthHash#expires? メソッド | E-02 (L15-17) | ○ |
| C-09 | AuthHash#expires_at メソッド | E-02 (L19-21) | ○ |
| C-10 | IdentityLinker#identity メソッド | E-03 (L13-17) | ○ |
| C-11 | TokenRefresher MIN_TIME_ALLOWED_TILL_EXPIRE定数 | E-04 (L10) | ○ |
| C-12 | TokenRefresher#needs_refresh? メソッド | E-04 (L17-19) | ○ |
| C-13 | TokenRefresher#refresh! メソッド | E-04 (L21-30) | ○ |
| C-14 | TokenRefresher#refresh_if_needed! メソッド | E-04 (L32-34) | ○ |
| C-15 | User.assign_identity_from_auth_hash! メソッド | E-05 (L7-14) | ○ |
| C-16 | User#find_by_uid_and_provider メソッド | E-05 (L18-20) | ○ |
| C-17 | User#add_or_update_user_identities メソッド | E-05 (L22-27) | ○ |
| C-18 | JiraConnect.app_name メソッド | E-06 (L6-8) | ○ |
| C-19 | JiraConnect.app_key メソッド（64文字制限） | E-06 (L10-14) | ○ |
| C-20 | JiraConnect.display_name メソッド | E-06 (L16-18) | ○ |
| C-21 | JiraIssueKeyExtractor.has_keys? メソッド | E-07 (L5-7) | ○ |
| C-22 | JiraIssueKeyExtractor#issue_keys メソッド | E-07 (L14-18) | ○ |
| C-23 | Client.generate_update_sequence_id メソッド | E-08 (L6-8) | ○ |
| C-24 | Client#send_info メソッド | E-08 (L15-33) | ○ |
| C-25 | Client#user_info メソッド | E-08 (L37-41) | ○ |
| C-26 | JwtValidator.valid_token_size? メソッド（8KB制限） | E-09 (L7-11) | ○ |
| C-27 | Jwt::Symmetric#iss_claim メソッド | E-10 (L15-17) | ○ |
| C-28 | Jwt::Symmetric#sub_claim メソッド | E-10 (L19-21) | ○ |
| C-29 | Jwt::Symmetric#valid? メソッド | E-10 (L23-27) | ○ |
| C-30 | Jwt::Symmetric#verify_qsh_claim メソッド | E-10 (L29-33) | ○ |
| C-31 | Jwt::Symmetric#verify_context_qsh_claim メソッド | E-10 (L35-37) | ○ |
| C-32 | Jwt::Asymmetric#valid? メソッド | E-11 (L24-26) | ○ |
| C-33 | Jwt::Asymmetric#iss_claim メソッド | E-11 (L28-32) | ○ |
| C-34 | JiraUser ADMIN_GROUPS定数 | E-12 (L6) | ○ |
| C-35 | JiraUser#jira_admin? メソッド | E-12 (L12-17) | ○ |
| C-36 | JiraIssueKeyExtractors::Branch.has_keys? メソッド | E-13 (L6-8) | ○ |
| C-37 | JiraIssueKeyExtractors::Branch#issue_keys メソッド（BatchLoader使用） | E-13 (L18-35) | ○ |
| C-38 | BaseEntity#update_sequence_id メソッド | E-14 (L22-24) | ○ |
| C-39 | BaseEntity#eql メソッド | E-14 (L14-16) | ○ |
| C-40 | BranchEntity#id（SHA256ハッシュ） | E-15 (L7-9) | ○ |
| C-41 | BranchEntity#issueKeys expose | E-15 (L10-12) | ○ |
| C-42 | BuildEntity#state ステータスマッピング | E-16 (L38-48) | ○ |
| C-43 | BuildEntity#issue_keys メソッド | E-16 (L24-26) | ○ |
| C-44 | BuildEntity#test_info メソッド | E-16 (L60-72) | ○ |
| C-45 | DeploymentEntity COMMITS_LIMIT/ISSUE_KEY_LIMIT/ASSOCIATION_LIMIT定数 | E-17 (L10-12) | ○ |
| C-46 | DeploymentEntity#state ステータスマッピング | E-17 (L87-98) | ○ |
| C-47 | DeploymentEntity#issue_keys メソッド（500件制限） | E-17 (L30-33) | ○ |
| C-48 | DeploymentEntity#associations メソッド | E-17 (L35-59) | ○ |
| C-49 | DeploymentEntity#generate_deployment_commands_from_integration_configuration | E-17 (L144-158) | ○ |
| C-50 | FeatureFlagEntity#issue_keys メソッド | E-18 (L22-24) | ○ |
| C-51 | FeatureFlagEntity STRATEGY_NAMES定数 | E-18 (L34-40) | ○ |
| C-52 | FeatureFlagEntity#summary メソッド | E-18 (L51-66) | ○ |
| C-53 | FeatureFlagEntity#details メソッド | E-18 (L68-79) | ○ |
| C-54 | PullRequestEntity STATUS_MAPPING定数 | E-19 (L7-12) | ○ |
| C-55 | PullRequestEntity#issueKeys expose | E-19 (L15-17) | ○ |
| C-56 | PullRequestEntity#status メソッド | E-19 (L38-40) | ○ |
| C-57 | PullRequestEntity#commentCount メソッド | E-19 (L26-32) | ○ |
| C-58 | RepositoryEntity#commits expose | E-20 (L17-19) | ○ |
| C-59 | RepositoryEntity#branches expose | E-20 (L20-22) | ○ |
| C-60 | RepositoryEntity#pullRequests expose | E-20 (L23-29) | ○ |
| C-61 | CommitEntity#issueKeys expose | E-21 (L10-12) | ○ |
| C-62 | CommitEntity#flags メソッド | E-21 (L16-22) | ○ |
| C-63 | CommitEntity#author メソッド（CommitAuthorフォールバック） | E-21 (L45-47) | ○ |
| C-64 | EnvironmentEntity#type メソッド（other -> unmapped） | E-22 (L22-24) | ○ |
| C-65 | EnvironmentEntity#display_name メソッド | E-22 (L18-20) | ○ |
| C-66 | ReviewerEntity#approvalStatus メソッド | E-23 (L16-28) | ○ |
| C-67 | FileEntity#changeType メソッド | E-24 (L12-23) | ○ |
| C-68 | FileEntity#path メソッド（削除ファイル処理） | E-24 (L9-11) | ○ |
| C-69 | PipelineEntity#display_name メソッド | E-25 (L21-23) | ○ |
| C-70 | AuthorEntity条件付き公開（CommitAuthor判定） | E-26 (L12-20) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接導出されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、根拠が明確

### 注意点
1. **セキュリティ関連テスト（UT-ATL-009〜012）**：attr_encryptedの動作は実際の暗号化/復号が行われることを確認する必要あり
2. **外部API連携テスト（UT-ATL-025〜026、053〜054）**：モック/スタブの適切な設定が必要
3. **JWT検証テスト（UT-ATL-060〜073）**：有効な/無効なJWTトークンの準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Atlassian::Identityモデルのバリデーションテストが網羅されているか
- [ ] トークン暗号化テストでattr_encryptedの動作が正しく検証されるか
- [ ] TokenRefresher の MIN_TIME_ALLOWED_TILL_EXPIRE (5分) 境界値テストが適切か
- [ ] JiraIssueKeyExtractor のカスタム正規表現対応テストが含まれているか
- [ ] JwtValidator の 8KB 制限テストが境界値を含めて適切か
- [ ] 各シリアライザのステータスマッピングテストが全パターン網羅されているか
- [ ] BatchLoaderを使用したN+1クエリ防止のテストが含まれているか
- [ ] DeploymentEntity の各種制限値（500件）のテストが含まれているか
- [ ] JiraUser の管理者グループ判定テストが両グループ（site-admins, org-admins）を網羅しているか
