---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 167
  claims_with_evidence: 167
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：audit_events 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：167 / 167、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにコードベースからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/audit_event.rb` - AuditEventモデル定義
- E-02: `app/models/audit_events/project_audit_event.rb` - ProjectAuditEventモデル定義
- E-03: `app/models/audit_events/group_audit_event.rb` - GroupAuditEventモデル定義
- E-04: `app/models/audit_events/user_audit_event.rb` - UserAuditEventモデル定義
- E-05: `app/models/audit_events/instance_audit_event.rb` - InstanceAuditEventモデル定義
- E-06: `app/models/concerns/audit_events/common_model.rb` - CommonModel共通concern
- E-07: `app/services/audit_events/build_service.rb` - AuditEvent構築サービス
- E-08: `app/services/audit_events/processor.rb` - AuditEvent処理サービス
- E-09: `lib/gitlab/audit/auditor.rb` - 監査イベント記録クラス
- E-10: `lib/gitlab/audit/null_author.rb` - Null Authorクラス
- E-11: `lib/gitlab/audit/deleted_author.rb` - 削除済みAuthorクラス
- E-12: `lib/gitlab/audit/unauthenticated_author.rb` - 未認証Authorクラス
- E-13: `lib/gitlab/audit/deploy_token_author.rb` - DeployToken Authorクラス
- E-14: `lib/gitlab/audit/deploy_key_author.rb` - DeployKey Authorクラス
- E-15: `lib/gitlab/audit/ci_runner_token_author.rb` - CI Runner Token Authorクラス
- E-16: `lib/gitlab/audit/target.rb` - Target抽象化クラス
- E-17: `lib/gitlab/audit/null_target.rb` - Null Targetクラス
- E-18: `lib/gitlab/audit/type/definition.rb` - 監査イベントタイプ定義クラス
- E-19: `lib/gitlab/audit/type/shared.rb` - 共通パラメータ定義
- E-20: `lib/gitlab/audit/scope_validation.rb` - スコープ検証モジュール
- E-21: `lib/gitlab/audit/logging.rb` - ロギングモジュール
- E-22: `lib/audit_events/http_timeout_config.rb` - HTTPタイムアウト設定
- E-23: `lib/audit_events/google_cloud/authentication.rb` - Google Cloud認証
- E-24: `lib/audit_events/google_cloud/logging_service/logger.rb` - Google Cloud Loggingサービス
- E-25: `app/policies/audit_events/definition_policy.rb` - 定義ポリシー

## 3) Claims と根拠の対応（レビューの主戦場）

### AuditEventモデル (UT-AUD-001 - UT-AUD-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initialize_detailsメソッドがdetails属性を空Hashで初期化 | E-01 (L61-65) | ○ |
| C-02 | author_nameがauthorの名前を返却 | E-01 (L67-69) | ○ |
| C-03 | formatted_detailsがfrom/toを文字列変換しauthor_emailを追加 | E-01 (L71-75) | ○ |
| C-04 | authorがlazy_authorまたはNullAuthorを返却 | E-01 (L77-79) | ○ |
| C-05 | lazy_authorがBatchLoaderで複数Userを一括取得 | E-01 (L81-87) | ○ |
| C-06 | as_jsonがip_addressを文字列に変換 | E-01 (L89-93) | ○ |
| C-07 | target_typeがカラム値またはdetailsから取得 | E-01 (L95-97) | ○ |
| C-08 | target_idがdetailsから取得 | E-01 (L99-101) | ○ |
| C-09 | target_detailsがカラム値またはdetailsから取得 | E-01 (L103-105) | ○ |
| C-10 | sanitize_messageがcustom_messageをサニタイズ | E-01 (L109-115) | ○ |
| C-11 | parallel_persistがカラムとdetailsを同期 | E-01 (L121-128) | ○ |
| C-12 | order_byがcreated_asc/descでソート | E-01 (L52-59) | ○ |
| C-13 | スコープby_entity_type/id/author_idが正しくフィルタリング | E-01 (L31-35) | ○ |
| C-14 | バリデーションがauthor_id/entity_id/entity_type/ip_addressを検証 | E-01 (L26-29) | ○ |

### CommonModel (UT-AUD-031 - UT-AUD-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | truncate_fieldsがentity_path/target_detailsを5500文字に切り詰め | E-06 (L15-18, L157-164) | ○ |
| C-16 | order_byがuse_created_atオプションでcreated_atを使用したソート | E-06 (L56-73) | ○ |
| C-17 | entity_pathがカラム値またはdetailsから取得 | E-06 (L126-128) | ○ |
| C-18 | ip_addressがカラム値を文字列変換またはdetailsから取得 | E-06 (L130-132) | ○ |

### スコープ付きAuditEventモデル (UT-AUD-040 - UT-AUD-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | ProjectAuditEventがproject_idを必須としby_projectスコープを持つ | E-02 (L9-11) | ○ |
| C-20 | GroupAuditEventがgroup_idを必須としby_groupスコープを持つ | E-03 (L9-11) | ○ |
| C-21 | UserAuditEventがuser_idを必須としby_user/by_usernameスコープを持つ | E-04 (L9-12) | ○ |
| C-22 | InstanceAuditEventがCommonModelをインクルード | E-05 (L7) | ○ |

### BuildService (UT-AUD-048 - UT-AUD-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 必須パラメータ（author/target/message）がblankの場合MissingAttributeError | E-07 (L16-18) | ○ |
| C-24 | validate_scope!で無効なスコープクラスを拒否 | E-07 (L20) | ○ |
| C-25 | executeがAuditEventインスタンスを返却 | E-07 (L35-37) | ○ |
| C-26 | build_authorがDeployToken/DeployKeyに特殊IDを設定 | E-07 (L66-71) | ○ |
| C-27 | build_targetがNullTargetまたはTargetでラップ | E-07 (L73-77) | ○ |
| C-28 | build_ip_addressがRequestContextまたはauthor.current_sign_in_ipから取得 | E-07 (L83-85) | ○ |

### Processor (UT-AUD-061 - UT-AUD-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | fetchがJSONまたはIDからAuditEventを取得 | E-08 (L5-18) | ○ |
| C-30 | fetch_from_idがmodel_class指定時にそのクラスから検索 | E-08 (L20-33) | ○ |
| C-31 | fetch_from_jsonがエンティティタイプに応じた監査イベントを生成 | E-08 (L35-52) | ○ |
| C-32 | determine_audit_model_entityがgroup_id/project_id/user_idから適切なモデルを決定 | E-08 (L54-71) | ○ |
| C-33 | create_scoped_audit_eventが不要なフィールドを除外 | E-08 (L73-84) | ○ |

### Auditor (UT-AUD-077 - UT-AUD-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | auditがブロックの有無でsingle_audit/multiple_auditを分岐 | E-09 (L52-64) | ○ |
| C-35 | 未定義のevent_nameでStandardErrorをスロー | E-09 (L85-89) | ○ |
| C-36 | recordがstream_onlyで処理を分岐 | E-09 (L103-105) | ○ |
| C-37 | log_to_databaseが単一/複数イベントで処理を分岐 | E-09 (L191-203) | ○ |
| C-38 | audit_enabled?がauthentication_event/permitted_targetで判定 | E-09 (L124-126) | ○ |
| C-39 | log_authentication_eventがAuthenticationEventを保存 | E-09 (L144-151) | ○ |
| C-40 | build_eventがBuildServiceを使用してイベント構築 | E-09 (L174-189) | ○ |
| C-41 | log_to_fileがAuditJsonLoggerにログ出力 | E-09 (L205-209) | ○ |

### NullAuthor系クラス (UT-AUD-097 - UT-AUD-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | NullAuthor.forがtarget_type/idに応じて適切なAuthorを返却 | E-10 (L18-35) | ○ |
| C-43 | UnauthenticatedAuthorがid=-1で初期化 | E-12 (L6-8) | ○ |
| C-44 | DeployTokenAuthorがid=-2で初期化 | E-13 (L6-8) | ○ |
| C-45 | DeployKeyAuthorがid=-3で初期化 | E-14 (L6-8) | ○ |
| C-46 | CiRunnerTokenAuthorがトークン種別に応じたnameを設定 | E-15 (L15-24) | ○ |
| C-47 | CiRunnerTokenAuthor.full_pathがentity_typeに応じたパスを返却 | E-15 (L31-43) | ○ |

### Target系クラス (UT-AUD-119 - UT-AUD-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Targetがオブジェクトのid/type/detailsを返却 | E-16 (L6-18) | ○ |
| C-49 | NullTargetが全てnilを返却 | E-17 (L6-16) | ○ |

### Type::Definition (UT-AUD-128 - UT-AUD-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | initializeがpath/attributesを設定 | E-18 (L31-38) | ○ |
| C-51 | validate_schemaがJSONスキーマで検証 | E-18 (L46-51) | ○ |
| C-52 | validate_file_nameがファイル名とnameの一致を検証 | E-18 (L54-62) | ○ |
| C-53 | defined?/get/stream_only?が定義の存在/内容を判定 | E-18 (L76-99) | ○ |

### ScopeValidation (UT-AUD-141 - UT-AUD-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | validate_scope!がProject/Group/Userのみを許可 | E-20 (L8-17) | ○ |

### Logging (UT-AUD-145 - UT-AUD-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | log_to_new_tablesがentity_typeごとにグループ化して保存 | E-21 (L13-22) | ○ |
| C-56 | additional_attributesがentity_typeに応じた属性を追加 | E-21 (L54-65) | ○ |

### Google Cloud連携 (UT-AUD-153 - UT-AUD-162)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Authenticationがアクセストークンを生成 | E-23 (L10-21) | ○ |
| C-58 | LoggingService::Loggerがアクセストークンを使用してPOSTリクエスト | E-24 (L14-22) | ○ |

### DefinitionPolicy/HttpTimeoutConfig (UT-AUD-163 - UT-AUD-167)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | DefinitionPolicyがaudit_event_definitionsを有効化 | E-25 (L5-9) | ○ |
| C-60 | HttpTimeoutConfigが8秒のタイムアウトを設定 | E-22 (L5-9) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースにソースコードからの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにコードベースからの直接的な根拠あり

特記事項：
- EE（Enterprise Edition）専用の拡張機能（`prepend_mod`で追加される機能）はCEコードベースからは確認できないため、EE環境でのテスト実行時には追加のテストケースが必要になる可能性がある
- `Gitlab::Audit::FeatureFlags`の挙動はfeature flagの状態に依存するため、テスト実行時には適切なfeature flag設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AuditEventモデルのバリデーション（author_id, entity_id, entity_type, ip_address）が正しくテストされているか
- [ ] CommonModelのtruncate_fieldsの境界値（5500文字）が適切にテストされているか
- [ ] BuildServiceの必須パラメータチェック（author, target, message, scope）が網羅されているか
- [ ] Processorのエンティティタイプ判定（group_id, project_id, user_id, instance）が全パターン網羅されているか
- [ ] NullAuthor.forの分岐条件（target_type=Ci::Runner, id=-1/-2/-3/その他）が全て網羅されているか
- [ ] Google Cloud連携の例外処理（RSAError, StandardError, HTTP_ERRORS）が適切にテストされているか
- [ ] EE専用機能（multiple_audit, send_to_stream等）のテストケースがEE環境で追加される必要があるか確認
