---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 106
  claims_with_evidence: 106
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：authn.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：106 / 106、根拠なし：0
- 優先レビュー（高）
  1. **認証関連のテストケース**：セキュリティの観点から重要
  2. **JWT検証サービス**：外部サービス連携の信頼性
  3. **データ保持Worker**：大量データ処理の安定性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/authn/oauth_application.rb` - OAuthアプリケーションモデル
- E-02: `app/models/authn/personal_access_token_last_used_ip.rb` - PAT最終利用IPモデル
- E-03: `app/services/authn/passkey/register_service.rb` - パスキー登録サービス
- E-04: `app/services/authn/passkey/authenticate_service.rb` - パスキー認証サービス
- E-05: `app/services/authn/passkey/destroy_service.rb` - パスキー削除サービス
- E-06: `app/services/authn/personal_access_tokens/create_granular_service.rb` - 粒度の細かいPAT作成サービス
- E-07: `app/services/authn/iam_service/jwt_validation_service.rb` - JWT検証サービス
- E-08: `app/workers/authn/data_retention/oauth_access_token_archive_worker.rb` - OAuthトークンアーカイブWorker
- E-09: `app/workers/authn/data_retention/oauth_access_grant_archive_worker.rb` - OAuthグラントアーカイブWorker
- E-10: `app/workers/authn/data_retention/authentication_event_archive_worker.rb` - 認証イベントアーカイブWorker
- E-11: `lib/authn/agnostic_token_identifier.rb` - トークン識別ユーティリティ
- E-12: `lib/authn/scoped_user_extractor.rb` - スコープからユーザーID抽出
- E-13: `lib/authn/iam_service/jwks_client.rb` - JWKSクライアント
- E-14: `lib/authn/token_field/base.rb` - トークンフィールド基底クラス
- E-15: `lib/authn/token_field/encrypted.rb` - 暗号化トークンフィールド
- E-16: `lib/authn/token_field/digest.rb` - ダイジェストトークンフィールド
- E-17: `lib/authn/token_field/encryption_helper.rb` - 暗号化ヘルパー
- E-18: `lib/authn/token_field/prefix_helper.rb` - プレフィックスヘルパー
- E-19: `lib/authn/token_field/generator/routable_token.rb` - ルーティング可能トークン生成
- E-20: `lib/authn/token_field/finders/base_encrypted.rb` - 暗号化トークン検索
- E-21: `lib/authn/tokens/personal_access_token.rb` - PAトークンクラス
- E-22: `lib/authn/tokens/deploy_token.rb` - デプロイトークンクラス
- E-23: `lib/authn/tokens/ci_job_token.rb` - CI Jobトークンクラス
- E-24: `lib/authn/tokens/feed_token.rb` - フィードトークンクラス
- E-25: `app/services/concerns/authn/webauthn_errors.rb` - WebAuthnエラーメッセージ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OauthApplication#secret_matches?の正常系テスト | E-01 (L17-31) | ○ |
| C-02 | OauthApplication#secret_matches?のinput nil異常系 | E-01 (L20) | ○ |
| C-03 | OauthApplication#secret_matches?のsecret nil異常系 | E-01 (L20) | ○ |
| C-04 | OauthApplication#secret_matches?のフォールバック | E-01 (L25-29) | ○ |
| C-05 | OauthApplication#secret_matches?の不一致 | E-01 (L30) | ○ |
| C-06 | OauthApplication#organizationリレーション | E-01 (L7) | ○ |
| C-07 | PersonalAccessTokenLastUsedIp#personal_access_tokenリレーション | E-02 (L6) | ○ |
| C-08 | PersonalAccessTokenLastUsedIp#organizationリレーション | E-02 (L7) | ○ |
| C-09 | RegisterService#execute正常系 | E-03 (L16-41) | ○ |
| C-10 | RegisterService#executeのJSONパースエラー | E-03 (L42-45) | ○ |
| C-11 | RegisterService#executeのRecordInvalid | E-03 (L46-49) | ○ |
| C-12 | RegisterService#executeのWebAuthnError | E-03 (L50-53) | ○ |
| C-13 | RegisterService#success_messageの2FA有効時 | E-03 (L63-67) | ○ |
| C-14 | RegisterService#success_messageの2FA無効時 | E-03 (L67-70) | ○ |
| C-15 | AuthenticateService#execute正常系 | E-04 (L16-36) | ○ |
| C-16 | AuthenticateService#executeのJSONパースエラー | E-04 (L37-40) | ○ |
| C-17 | AuthenticateService#executeのRecordNotFound | E-04 (L41-44) | ○ |
| C-18 | AuthenticateService#executeのWebAuthnError | E-04 (L45-48) | ○ |
| C-19 | AuthenticateService#validate_passkey_credential正常系 | E-04 (L91-95) | ○ |
| C-20 | AuthenticateService#validate_passkey_credentialの不正type | E-04 (L92) | ○ |
| C-21 | DestroyService#execute正常系 | E-05 (L14-23) | ○ |
| C-22 | DestroyService#executeの認可エラー | E-05 (L15) | ○ |
| C-23 | DestroyService#executeのパスキー未検出 | E-05 (L11) | ○ |
| C-24 | CreateGranularService#execute正常系 | E-06 (L15-42) | ○ |
| C-25 | CreateGranularService#executeの空スコープエラー | E-06 (L18) | ○ |
| C-26 | CreateGranularService#executeのトークン作成失敗ロールバック | E-06 (L26) | ○ |
| C-27 | CreateGranularService#executeのスコープ追加失敗ロールバック | E-06 (L34) | ○ |
| C-28 | JwtValidationService#execute正常系 | E-07 (L18-25) | ○ |
| C-29 | JwtValidationService#executeのIAM無効 | E-07 (L19-21) | ○ |
| C-30 | JwtValidationService#executeのJWKS取得失敗 | E-07 (L26-27) | ○ |
| C-31 | JwtValidationService#executeの期限切れトークン | E-07 (L53) | ○ |
| C-32 | JwtValidationService#executeの不正issuer | E-07 (L55) | ○ |
| C-33 | JwtValidationService#executeの不正audience | E-07 (L56) | ○ |
| C-34 | JwtValidationService#decode_with_retryのリトライ | E-07 (L36-44) | ○ |
| C-35 | JwtValidationService#decode_with_retryのリトライ失敗 | E-07 (L39) | ○ |
| C-36 | OauthAccessTokenArchiveWorker#perform正常系 | E-08 (L22-55) | ○ |
| C-37 | OauthAccessTokenArchiveWorker#performの設定無効 | E-08 (L23) | ○ |
| C-38 | OauthAccessTokenArchiveWorker#performのフラグ無効 | E-08 (L24) | ○ |
| C-39 | OauthAccessTokenArchiveWorker#performの再キュー | E-08 (L44-47) | ○ |
| C-40 | OauthAccessGrantArchiveWorker#perform正常系 | E-09 (L23-56) | ○ |
| C-41 | OauthAccessGrantArchiveWorker#performの設定無効 | E-09 (L24) | ○ |
| C-42 | AuthenticationEventArchiveWorker#perform正常系 | E-10 (L22-57) | ○ |
| C-43 | AuthenticationEventArchiveWorker#performの設定無効 | E-10 (L23) | ○ |
| C-44 | AgnosticTokenIdentifier.token_forのPAT | E-11 (L21-23) | ○ |
| C-45 | AgnosticTokenIdentifier.token_forのDeployToken | E-11 (L21-23, L8) | ○ |
| C-46 | AgnosticTokenIdentifier.token_forの未知トークン | E-11 (L22) | ○ |
| C-47 | AgnosticTokenIdentifier.token?のtrue | E-11 (L25-27) | ○ |
| C-48 | AgnosticTokenIdentifier.token?のfalse | E-11 (L26) | ○ |
| C-49 | AgnosticTokenIdentifier.nameのトークン名 | E-11 (L33-39) | ○ |
| C-50 | ScopedUserExtractor#extract_user_id_from_scopes正常系 | E-12 (L9-13) | ○ |
| C-51 | ScopedUserExtractor#extract_user_id_from_scopesのuser:なし | E-12 (L11) | ○ |
| C-52 | ScopedUserExtractor#extract_user_id_from_scopesの複数user: | E-12 (L11) | ○ |
| C-53 | JwksClient#fetch_keysのキャッシュヒット | E-13 (L14-16) | ○ |
| C-54 | JwksClient#fetch_keysのキャッシュミス | E-13 (L31-49) | ○ |
| C-55 | JwksClient#fetch_keysのHTTPエラー | E-13 (L34-36) | ○ |
| C-56 | JwksClient#fetch_keysの接続エラー | E-13 (L50-52) | ○ |
| C-57 | JwksClient#fetch_keysの不正JWKS形式 | E-13 (L41-43) | ○ |
| C-58 | JwksClient#refresh_keysのキャッシュクリア | E-13 (L20-23) | ○ |
| C-59 | JwksClient#service_urlのURL未設定 | E-13 (L71-75) | ○ |
| C-60 | TokenField::Base.fabricateのencrypted | E-14 (L11-21) | ○ |
| C-61 | TokenField::Base.fabricateのinsecure | E-14 (L18) | ○ |
| C-62 | TokenField::Base.fabricateのdigestデフォルト | E-14 (L20) | ○ |
| C-63 | TokenField::Base.fabricateの互換性エラー | E-14 (L12-13) | ○ |
| C-64 | TokenField::Base#ensure_tokenの新規生成 | E-14 (L56-58) | ○ |
| C-65 | TokenField::Base#ensure_tokenの既存返却 | E-14 (L57) | ○ |
| C-66 | TokenField::Base#expired?の期限切れ | E-14 (L77-82) | ○ |
| C-67 | TokenField::Base#expired?の期限内 | E-14 (L81) | ○ |
| C-68 | TokenField::Base#expired?のnilexpires_at | E-14 (L81) | ○ |
| C-69 | Encrypted#find_token_authenticatableの暗号化検索 | E-15 (L10-24) | ○ |
| C-70 | Encrypted#find_token_authenticatableのoptionalプレーン | E-15 (L17-18) | ○ |
| C-71 | Encrypted#find_token_authenticatableの空トークン | E-15 (L11) | ○ |
| C-72 | Encrypted#set_tokenの暗号化設定 | E-15 (L57-64) | ○ |
| C-73 | Encrypted#set_tokenの空トークンエラー | E-15 (L58) | ○ |
| C-74 | Digest#find_token_authenticatableのダイジェスト検索 | E-16 (L10-14) | ○ |
| C-75 | Digest#encodeのSHA256 | E-16 (L20-22) | ○ |
| C-76 | Digest#set_tokenの設定 | E-16 (L24-30) | ○ |
| C-77 | EncryptionHelper.encrypt_tokenの暗号化 | E-17 (L23-27) | ○ |
| C-78 | EncryptionHelper.decrypt_tokenの動的nonce復号 | E-17 (L9-21) | ○ |
| C-79 | EncryptionHelper.decrypt_tokenの静的IV復号 | E-17 (L18-20) | ○ |
| C-80 | EncryptionHelper.decrypt_tokenのnil | E-17 (L10) | ○ |
| C-81 | PrefixHelper.prepend_instance_prefixの付与 | E-18 (L6-11) | ○ |
| C-82 | PrefixHelper.prepend_instance_prefixのフラグ無効 | E-18 (L7) | ○ |
| C-83 | PrefixHelper.instance_prefixの取得 | E-18 (L13-19) | ○ |
| C-84 | RoutableToken#generate_tokenの生成 | E-19 (L42-48) | ○ |
| C-85 | RoutableToken#generate_tokenの必須キー不足 | E-19 (L88-93) | ○ |
| C-86 | RoutableToken#generate_tokenの無効キー | E-19 (L95-100) | ○ |
| C-87 | RoutableToken#generate_tokenのサイズ超過 | E-19 (L102-106) | ○ |
| C-88 | RoutableToken.crc_ofのCRC計算 | E-19 (L28-30) | ○ |
| C-89 | BaseEncrypted#executeの検索 | E-20 (L18-20) | ○ |
| C-90 | BaseEncrypted#initializeの戦略検証 | E-20 (L7-11) | ○ |
| C-91 | PersonalAccessToken.prefix?のglpat | E-21 (L6-14) | ○ |
| C-92 | PersonalAccessToken.prefix?のカスタム | E-21 (L9) | ○ |
| C-93 | PersonalAccessToken#revoke!の人間ユーザー | E-21 (L47-52) | ○ |
| C-94 | PersonalAccessToken#revoke!のプロジェクトbot | E-21 (L49-50) | ○ |
| C-95 | PersonalAccessToken#revoke!の未検出 | E-21 (L28) | ○ |
| C-96 | DeployToken.prefix?のgldt | E-22 (L6-11) | ○ |
| C-97 | DeployToken#revoke!のグループ | E-22 (L40-41) | ○ |
| C-98 | DeployToken#revoke!のプロジェクト | E-22 (L43-44) | ○ |
| C-99 | CiJobToken.prefix?のプレフィックス | E-23 (L6-9) | ○ |
| C-100 | CiJobToken#revoke!の取り消し不可 | E-23 (L23-27) | ○ |
| C-101 | FeedToken.prefix?のglft | E-24 (L6-11) | ○ |
| C-102 | FeedToken#revoke!のリセット | E-24 (L24-32) | ○ |
| C-103 | WebauthnErrors#webauthn_human_readable_errorsのwebauthn | E-25 (L75-85) | ○ |
| C-104 | WebauthnErrors#webauthn_human_readable_errorsのpasskey | E-25 (L78-80) | ○ |
| C-105 | WebauthnErrors#webauthn_human_readable_errorsの未知 | E-25 (L80, 83) | ○ |
| C-106 | WebauthnErrors#webauthn_human_readable_errorsのnil | E-25 (L76) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに直接対応

## 6) レビュアーチェックリスト（最小）
- [ ] 認証関連テスト（UT-ATN-001〜UT-ATN-023）のセキュリティ観点の妥当性確認
- [ ] JWT検証テスト（UT-ATN-028〜UT-ATN-035）のエラーハンドリング網羅性確認
- [ ] データ保持Workerテスト（UT-ATN-036〜UT-ATN-043）のバッチ処理境界条件確認
- [ ] トークン暗号化テスト（UT-ATN-069〜UT-ATN-080）の暗号化方式検証
- [ ] 各トークンタイプ（PAT, DeployToken, CiJobToken, FeedToken）の取り消しロジック確認
