---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 147
  claims_with_evidence: 147
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：authz.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：147 / 147、根拠なし：0
- 優先レビュー（高）
  1. **認可ロジック（GranularScope.permitted_for_boundary?等）**：ビジネスクリティカルな認可判定
  2. **権限チェック（BoundaryPolicy、AdminConstraint）**：セキュリティ上重要
  3. **サービスクラスのエラーハンドリング**：実運用での障害対応に影響

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/authz/granular_scope.rb` - GranularScopeモデル定義
- E-02: `app/models/authz/personal_access_token_granular_scope.rb` - PersonalAccessTokenGranularScopeモデル定義
- E-03: `app/models/authz/boundary.rb` - Boundaryクラス群定義
- E-04: `app/models/concerns/authz/has_roles.rb` - HasRoles concern定義
- E-05: `app/services/authz/granular_scope_service.rb` - GranularScopeServiceサービス定義
- E-06: `app/services/authz/applications/reset_secret_service.rb` - ResetSecretServiceサービス定義
- E-07: `app/services/authz/redaction_service.rb` - RedactionServiceサービス定義
- E-08: `app/services/authz/tokens/authorize_granular_scopes_service.rb` - AuthorizeGranularScopesServiceサービス定義
- E-09: `app/constraints/authz/admin_constraint.rb` - AdminConstraint制約定義
- E-10: `app/policies/authz/boundary_policy.rb` - BoundaryPolicyポリシー定義
- E-11: `lib/authz/permission.rb` - Permissionクラス定義
- E-12: `lib/authz/resource.rb` - Resourceクラス定義
- E-13: `lib/authz/permission_groups/assignable.rb` - Assignableクラス定義
- E-14: `lib/authz/concerns/yaml_permission.rb` - YamlPermission concern定義
- E-15: `lib/api/helpers/authz/postfiltering_helpers.rb` - PostfilteringHelpersモジュール定義
- E-16: `lib/gitlab/graphql/authz/granular_token_authorization.rb` - GranularTokenAuthorizationクラス定義
- E-17: `lib/gitlab/graphql/authz/directive_finder.rb` - DirectiveFinderクラス定義
- E-18: `lib/gitlab/graphql/authz/boundary_extractor.rb` - BoundaryExtractorクラス定義
- E-19: `lib/gitlab/graphql/authz/type_unwrapper.rb` - TypeUnwrapperモジュール定義
- E-20: `lib/gitlab/graphql/authz/skip_rules.rb` - SkipRulesクラス定義
- E-21: `lib/gitlab/graphql/authz/authorize_granular_token.rb` - AuthorizeGranularTokenモジュール定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Authz::GranularScope (C-01 〜 C-23)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | organizationリレーションが正しく取得できること | E-01 (L7) | ○ |
| C-02 | namespaceリレーションが正しく取得できること | E-01 (L13) | ○ |
| C-03 | namespaceがnilの場合もスコープが有効であること | E-01 (L9-12 コメント) | ○ |
| C-04 | 有効なpermissions JSONが受け入れられること | E-01 (L15) | ○ |
| C-05 | 無効なpermissions JSONがエラーとなること | E-01 (L15) | ○ |
| C-06 | permissions JSONが64KB以内であること | E-01 (L15 size_limit) | ○ |
| C-07 | permissions JSONが64KB超過でエラーとなること | E-01 (L15 size_limit) | ○ |
| C-08 | namespaceのorganizationが異なる場合エラー | E-01 (L75-78) | ○ |
| C-09 | namespaceのorganizationが一致する場合成功 | E-01 (L75-78) | ○ |
| C-10 | scope :with_namespaceが正しく動作 | E-01 (L18) | ○ |
| C-11 | scope :for_standaloneが正しく動作 | E-01 (L19-21) | ○ |
| C-12 | scope :for_namespacesが正しく動作 | E-01 (L22-25) | ○ |
| C-13 | enum :access PERSONAL_PROJECTS | E-01 (L27-43) | ○ |
| C-14 | enum :access ALL_MEMBERSHIPS | E-01 (L27-43) | ○ |
| C-15 | enum :access SELECTED_MEMBERSHIPS | E-01 (L27-43) | ○ |
| C-16 | enum :access USER | E-01 (L27-43) | ○ |
| C-17 | enum :access INSTANCE | E-01 (L27-43) | ○ |
| C-18 | permitted_for_boundary?が権限ありでtrue | E-01 (L47-50) | ○ |
| C-19 | permitted_for_boundary?が権限不足でfalse | E-01 (L47-50) | ○ |
| C-20 | permitted_for_boundary?が空配列でtrue | E-01 (L47-50) | ○ |
| C-21 | token_permissionsがUSER/INSTANCEで動作 | E-01 (L53-67) | ○ |
| C-22 | token_permissionsがSELECTED_MEMBERSHIPSで動作 | E-01 (L53-67) | ○ |
| C-23 | build_copyがCOPYABLE_ATTRIBUTESのみコピー | E-01 (L5, L69-71) | ○ |

### Authz::PersonalAccessTokenGranularScope (C-24 〜 C-26)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | organizationリレーション | E-02 (L5) | ○ |
| C-25 | personal_access_tokenリレーション | E-02 (L6) | ○ |
| C-26 | granular_scopeリレーション（autosave有効） | E-02 (L7) | ○ |

### Authz::Boundary (C-27 〜 C-48)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | GroupがGroupBoundaryに変換 | E-03 (L6-8) | ○ |
| C-28 | ProjectがProjectBoundaryに変換 | E-03 (L9-10) | ○ |
| C-29 | UserがPersonalProjectsBoundaryに変換 | E-03 (L11-12) | ○ |
| C-30 | :all_membershipsがNilBoundaryに変換 | E-03 (L13-16) | ○ |
| C-31 | :userがNilBoundaryに変換 | E-03 (L13-16) | ○ |
| C-32 | :instanceがNilBoundaryに変換 | E-03 (L13-16) | ○ |
| C-33 | 未対応オブジェクトでnilが返却 | E-03 (L19) | ○ |
| C-34 | GroupBoundary.accessがSELECTED_MEMBERSHIPS | E-03 (L41-43) | ○ |
| C-35 | GroupBoundary.namespaceがGroup自身 | E-03 (L45-47) | ○ |
| C-36 | GroupBoundary.member?がメンバーでtrue | E-03 (L49-51) | ○ |
| C-37 | GroupBoundary.member?が非メンバーでfalse | E-03 (L49-51) | ○ |
| C-38 | ProjectBoundary.accessがSELECTED_MEMBERSHIPS | E-03 (L55-57) | ○ |
| C-39 | ProjectBoundary.namespaceがproject_namespace | E-03 (L59-61) | ○ |
| C-40 | ProjectBoundary.member? | E-03 (L63-65) | ○ |
| C-41 | PersonalProjectsBoundary.accessがPERSONAL_PROJECTS | E-03 (L69-71) | ○ |
| C-42 | PersonalProjectsBoundary.namespaceがuser.namespace | E-03 (L73-75) | ○ |
| C-43 | NilBoundary.accessがboundaryパラメータ | E-03 (L84-86) | ○ |
| C-44 | NilBoundary.namespaceがnil | E-03 (L88-90) | ○ |
| C-45 | NilBoundary.member?が常にtrue | E-03 (L92-94) | ○ |
| C-46 | NilBoundary.pathがnil | E-03 (L96-98) | ○ |
| C-47 | Base.pathがnamespace.full_path | E-03 (L31-33) | ○ |
| C-48 | Base.declarative_policy_class | E-03 (L23-25) | ○ |

### Authz::HasRoles (C-49 〜 C-54)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | roles_user_can_assignがアクセスレベル以下返却 | E-04 (L7-14) | ○ |
| C-50 | Ownerが全ロール割り当て可能 | E-04 (L7-14) | ○ |
| C-51 | 指定rolesがフィルタされる | E-04 (L8) | ○ |
| C-52 | can_assign_role?が割り当て可能でtrue | E-04 (L16-22) | ○ |
| C-53 | can_assign_role?が割り当て不可でfalse | E-04 (L16-22) | ○ |
| C-54 | can_assign_role?がnil入力でtrue | E-04 (L17) | ○ |

### Authz::GranularScopeService (C-55 〜 C-62)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | initializeでPAT設定 | E-05 (L5-7) | ○ |
| C-56 | add_granular_scopesで単一スコープ追加 | E-05 (L9-28) | ○ |
| C-57 | add_granular_scopesで複数スコープ追加 | E-05 (L10) | ○ |
| C-58 | 重複namespace_idでエラー | E-05 (L35-44) | ○ |
| C-59 | 複数インスタンスレベルスコープでエラー | E-05 (L38-42) | ○ |
| C-60 | 永続化済みPATで保存実行 | E-05 (L26) | ○ |
| C-61 | 未永続化PATで保存スキップ | E-05 (L26) | ○ |
| C-62 | organization_idがPATから継承 | E-05 (L18) | ○ |

### Authz::Applications::ResetSecretService (C-63 〜 C-66)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | initializeでapplication/current_user設定 | E-06 (L8-11) | ○ |
| C-64 | 管理者権限でシークレットリセット成功 | E-06 (L13-20) | ○ |
| C-65 | 管理者権限なしでエラー | E-06 (L14, L29-31) | ○ |
| C-66 | 保存失敗時エラー | E-06 (L18-20) | ○ |

### Authz::RedactionService (C-67 〜 C-75)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | initializeで各パラメータ設定 | E-07 (L53-59) | ○ |
| C-68 | user=nilでArgumentError | E-07 (L54) | ○ |
| C-69 | 空resources_by_typeで空ハッシュ | E-07 (L63) | ○ |
| C-70 | 読み取り権限ありでtrue | E-07 (L117-121) | ○ |
| C-71 | 読み取り権限なしでfalse | E-07 (L117-121) | ○ |
| C-72 | 存在しないリソースIDでfalse | E-07 (L111) | ○ |
| C-73 | 複数タイプ処理 | E-07 (L67-71) | ○ |
| C-74 | 未対応タイプで全false | E-07 (L106) | ○ |
| C-75 | supported_typesが正しく返却 | E-07 (L49-51) | ○ |

### Authz::Tokens::AuthorizeGranularScopesService (C-76 〜 C-83)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | initializeで各パラメータ設定 | E-08 (L10-16) | ○ |
| C-77 | 無効boundary型でInvalidInputError | E-08 (L35-39) | ○ |
| C-78 | 無効permissionでInvalidInputError | E-08 (L42-48) | ○ |
| C-79 | 認可チェック不要時に成功 | E-08 (L19) | ○ |
| C-80 | 機能フラグ無効時にエラー | E-08 (L20, L82-84) | ○ |
| C-81 | 入力不足時にエラー | E-08 (L21, L86-88) | ○ |
| C-82 | 全権限認可で成功 | E-08 (L23, L90-91) | ○ |
| C-83 | 権限不足でエラー | E-08 (L23, L94-99) | ○ |

### Authz::AdminConstraint (C-84 〜 C-90)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | admin_mode有効時の判定 | E-09 (L6-7) | ○ |
| C-85 | admin_mode無効時の判定 | E-09 (L8-9) | ○ |
| C-86 | 認証済み管理者でtrue | E-09 (L15-17) | ○ |
| C-87 | 認証済み非管理者でfalse | E-09 (L15-17) | ○ |
| C-88 | 未認証でfalse | E-09 (L16) | ○ |
| C-89 | admin_mode有効ユーザーでtrue | E-09 (L19-22) | ○ |
| C-90 | admin_mode無効ユーザーでfalse | E-09 (L19-22) | ○ |

### Authz::BoundaryPolicy (C-91 〜 C-95)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | granular PAT conditionがtrue | E-10 (L8-10) | ○ |
| C-92 | 非granular PAT conditionがfalse | E-10 (L8-10) | ○ |
| C-93 | can_read_all_resources?でmember true | E-10 (L18-21) | ○ |
| C-94 | boundary.member?でmember true | E-10 (L18-21) | ○ |
| C-95 | 全条件満たしてpermission有効化 | E-10 (L24-26) | ○ |

### Authz::Concerns::YamlPermission (C-96 〜 C-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | self.allで全定義読み込み | E-14 (L12-14) | ○ |
| C-97 | self.getで名前から取得 | E-14 (L16-18) | ○ |
| C-98 | self.getで存在しない名前にnil | E-14 (L16-18) | ○ |
| C-99 | self.defined?で存在確認 | E-14 (L20-22) | ○ |
| C-100 | nameがdefinition[:name]返却 | E-14 (L61-63) | ○ |
| C-101 | descriptionがdefinition[:description]返却 | E-14 (L65-67) | ○ |
| C-102 | actionがファイル名返却 | E-14 (L69-71) | ○ |
| C-103 | resourceが親ディレクトリ名返却 | E-14 (L73-78) | ○ |
| C-104 | boundariesが配列返却 | E-14 (L92-94) | ○ |
| C-105 | boundaries未定義で空配列 | E-14 (L92-94) | ○ |

### Authz::Permission / Authz::Resource (C-106 〜 C-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Permission.config_path | E-11 (L9-12) | ○ |
| C-107 | Resource.config_path | E-12 (L9-11) | ○ |
| C-108 | Resource.name | E-12 (L24-26) | ○ |
| C-109 | Resource.resource_name | E-12 (L28-30) | ○ |
| C-110 | Resource.feature_category | E-12 (L32-34) | ○ |

### Authz::PermissionGroups::Assignable (C-111 〜 C-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | all_permissionsがユニーク配列 | E-13 (L11-13) | ○ |
| C-112 | for_permissionが逆引き | E-13 (L15-17) | ○ |
| C-113 | permissionsがシンボル配列 | E-13 (L28-30) | ○ |
| C-114 | categoryがパスから抽出 | E-13 (L32-37) | ○ |

### API::Helpers::Authz::PostfilteringHelpers (C-115 〜 C-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | feature有効時にログ出力 | E-15 (L8-26) | ○ |
| C-116 | feature無効時にログ出力なし | E-15 (L24-26) | ○ |
| C-117 | 例外発生時にwarnログ後re-raise | E-15 (L27-36) | ○ |

### Gitlab::Graphql::Authz::GranularTokenAuthorization (C-118 〜 C-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | 認可成功時に後続処理実行 | E-16 (L10-13) | ○ |
| C-119 | 認可失敗時に例外発生 | E-16 (L46) | ○ |
| C-120 | authorization_enabled?がtrue条件 | E-16 (L29-32) | ○ |
| C-121 | authorization_enabled?がfalse条件 | E-16 (L29-32) | ○ |
| C-122 | キャッシュヒット時にスキップ | E-16 (L38) | ○ |
| C-123 | キャッシュミス時に認可実行 | E-16 (L34-48) | ○ |

### Gitlab::Graphql::Authz::DirectiveFinder (C-124 〜 C-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | field上のdirective検索 | E-17 (L23-25) | ○ |
| C-125 | owner上のdirective検索 | E-17 (L27-29) | ○ |
| C-126 | implementing type上のdirective検索 | E-17 (L31-36) | ○ |
| C-127 | return type上のdirective検索 | E-17 (L38-42) | ○ |
| C-128 | directive見つからない場合nil | E-17 (L53-57) | ○ |

### Gitlab::Graphql::Authz::BoundaryExtractor (C-129 〜 C-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | スタンドアロンboundary抽出 | E-18 (L25-26) | ○ |
| C-130 | boundary_argumentから抽出 | E-18 (L39-40) | ○ |
| C-131 | methodから抽出 | E-18 (L42-47) | ○ |
| C-132 | GlobalIDから解決 | E-18 (L81-86) | ○ |
| C-133 | full_pathから解決 | E-18 (L99-101) | ○ |
| C-134 | 無効boundaryメソッドでエラー | E-18 (L64-66) | ○ |
| C-135 | boundaryメソッド未存在でエラー | E-18 (L68-70) | ○ |

### Gitlab::Graphql::Authz::TypeUnwrapper (C-136 〜 C-139)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | List型アンラップ | E-19 (L15-23) | ○ |
| C-137 | NonNull型アンラップ | E-19 (L15-23) | ○ |
| C-138 | Connection型アンラップ | E-19 (L18-19) | ○ |
| C-139 | ネスト型完全アンラップ | E-19 (L15-23) | ○ |

### Gitlab::Graphql::Authz::SkipRules (C-140 〜 C-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | mutation response fieldでtrue | E-20 (L23-27) | ○ |
| C-141 | permission type fieldでtrue | E-20 (L35-37) | ○ |
| C-142 | return typeがpermission typeでtrue | E-20 (L39-44) | ○ |
| C-143 | 通常fieldでfalse | E-20 (L15-18) | ○ |

### Gitlab::Graphql::Authz::AuthorizeGranularToken (C-144 〜 C-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | granular_scope_directiveが有効なハッシュ生成 | E-21 (L11-19) | ○ |
| C-145 | authorize_granular_tokenがディレクティブ適用 | E-21 (L22-29) | ○ |
| C-146 | permissionsが大文字配列に変換 | E-21 (L35) | ○ |
| C-147 | nil値がcompact | E-21 (L38) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全テストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードから直接導出されており、コード根拠が明確
- **注意点**:
  - 認可ロジック（GranularScope.permitted_for_boundary?、BoundaryPolicy）はセキュリティクリティカルなため、実装テスト時に追加の境界値テストを検討
  - YAMLパーミッション定義ファイルの実際の内容は確認していないため、config/authz/permissions/配下のYAMLファイルを参照した追加テストが必要な場合あり

## 6) レビュアーチェックリスト（最小）
- [ ] 認可判定ロジック（GranularScope.permitted_for_boundary?、token_permissions）のテストケースが十分か
- [ ] エラーメッセージの内容が要件と一致しているか
- [ ] AdminConstraintのadmin_mode分岐が正しくテストされているか
- [ ] RedactionServiceのリソースタイプ（issues, merge_requests等）の網羅性
- [ ] GraphQL認可フロー（GranularTokenAuthorization）のキャッシュ機構のテストが十分か
- [ ] BoundaryExtractorの各抽出パターン（standalone, argument, method, GlobalID, full_path）の網羅性
