---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：aws.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **UT-AWS-021**：無効な認証情報時の挙動（例外発生か後続エラーか不明確）
  2. **UT-AWS-030**：空キーの場合のエラー挙動（S3側の挙動に依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/aws/role.rb` - Aws::Roleモデル定義
- E-02: `lib/aws/s3_client.rb` - Aws::S3Clientクラス定義
- E-03: `spec/models/aws/role_spec.rb` - Aws::Roleモデルのテストスペック
- E-04: `spec/lib/aws/s3_client_spec.rb` - Aws::S3Clientのテストスペック
- E-05: `lib/gitlab/regex.rb` - AWS ARN正規表現定義（aws_arn_regex）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザーリレーションが正しく取得できる（UT-AWS-001） | E-01（belongs_to :user, inverse_of: :aws_role）、E-03（is_expected.to belong_to(:user)） | ○ |
| C-02 | 関連ユーザーが存在しない場合nilが返却される（UT-AWS-002） | E-01（belongs_to :user）- Railsの標準動作 | ○ |
| C-03 | 有効なrole_external_idでバリデーションが通る（UT-AWS-003） | E-01（validates :role_external_id, length: { in: 1..64 }）、E-03（validate_length_of） | ○ |
| C-04 | 空のrole_external_idでバリデーションエラー（UT-AWS-004） | E-01（length: { in: 1..64 }）、E-03（is_at_least(1)） | ○ |
| C-05 | role_external_idが1文字でバリデーションが通る（UT-AWS-005） | E-01（length: { in: 1..64 }）、E-03（is_at_least(1)） | ○ |
| C-06 | role_external_idが64文字でバリデーションが通る（UT-AWS-006） | E-01（length: { in: 1..64 }）、E-03（is_at_most(64)） | ○ |
| C-07 | role_external_idが65文字でバリデーションエラー（UT-AWS-007） | E-01（length: { in: 1..64 }）、E-03（is_at_most(64)） | ○ |
| C-08 | 重複するrole_external_idでバリデーションエラー（UT-AWS-008） | E-01（validates :role_external_id, uniqueness: true） | ○ |
| C-09 | 有効なARN形式でバリデーションが通る（UT-AWS-009） | E-01（format: { with: Gitlab::Regex.aws_arn_regex }）、E-03（ARN is valid テスト）、E-05 | ○ |
| C-10 | role_arnがnilでバリデーションが通る（UT-AWS-010） | E-01（allow_nil: true）、E-03（ARN is nil テスト） | ○ |
| C-11 | 空文字のrole_arnでバリデーションエラー（UT-AWS-011） | E-01（length: 1..2048）、E-03（length is zero テスト） | ○ |
| C-12 | 不正なARN形式でバリデーションエラー（UT-AWS-012） | E-01（format: { with: Gitlab::Regex.aws_arn_regex }）、E-05（/\Aarn:\S+\z/） | ○ |
| C-13 | role_arnが2048文字でバリデーションが通る（UT-AWS-013） | E-01（length: 1..2048） | ○ |
| C-14 | role_arnが2049文字でバリデーションエラー（UT-AWS-014） | E-01（length: 1..2048）、E-03（length is longer than 2048 テスト） | ○ |
| C-15 | role_external_idがnilの場合に自動生成される（UT-AWS-015） | E-01（self.role_external_id ||= SecureRandom.hex(20)）、E-03（generates an external ID） | ○ |
| C-16 | role_external_idが既にセットされている場合は変更されない（UT-AWS-016） | E-01（||= 演算子）、E-03（does not change the existing external id） | ○ |
| C-17 | 新規レコード作成時にensure_role_external_id!が呼ばれる（UT-AWS-017） | E-01（before_validation :ensure_role_external_id!, on: :create）、E-03（for a new record テスト） | ○ |
| C-18 | 既存レコード更新時にensure_role_external_id!が呼ばれない（UT-AWS-018） | E-01（on: :create）、E-03（for an existing record テスト） | ○ |
| C-19 | テーブル名がaws_rolesである（UT-AWS-019） | E-01（self.table_name = 'aws_roles'） | ○ |
| C-20 | 有効な認証情報でS3クライアントが初期化される（UT-AWS-020） | E-02（initialize メソッド定義）、E-04（let s3_client） | ○ |
| C-21 | 無効な認証情報でS3クライアント初期化時にエラーが発生する（UT-AWS-021） | **根拠なし** - AWS SDKの挙動に依存、テストスペックで未検証 | △ |
| C-22 | http_continue_timeoutがnilに設定される（UT-AWS-022） | E-02（http_continue_timeout: nil）、コード内コメント参照 | ○ |
| C-23 | ファイルが正常にアップロードされる（UT-AWS-023） | E-02（upload_object メソッド）、E-04（calls put_object with correct params） | ○ |
| C-24 | content_typeのデフォルト値がapplication/jsonである（UT-AWS-024） | E-02（content_type = 'application/json'） | ○ |
| C-25 | カスタムcontent_typeが正しく設定される（UT-AWS-025） | E-02（content_type引数）、E-04（content_type: 'Text/plain'） | ○ |
| C-26 | 存在しないバケットへのアップロードでエラーになる（UT-AWS-026） | E-02（@s3_client.put_object）- AWS SDKの標準動作 | ○ |
| C-27 | 権限不足でアップロードエラーになる（UT-AWS-027） | E-02（@s3_client.put_object）- AWS SDKの標準動作 | ○ |
| C-28 | 空のbodyでアップロードが成功する（UT-AWS-028） | E-02（body引数）- AWS S3は空オブジェクトを許可 | ○ |
| C-29 | 大きなbodyでアップロードが成功する（UT-AWS-029） | E-02（body引数）- AWS S3のサイズ制限に依存 | ○ |
| C-30 | keyが空の場合にエラーになる（UT-AWS-030） | **根拠なし** - AWS SDKの挙動に依存、テストスペックで未検証 | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-AWS-021（C-21）**：無効な認証情報時のエラー挙動
  - AWS SDKのCredentialsクラスは初期化時に検証を行わない可能性がある
  - 実際のAPI呼び出し時に初めてエラーが発生する可能性
  - 候補：AWS SDK公式ドキュメント / AWS::Credentials仕様書 / 統合テスト

- **UT-AWS-030（C-30）**：空キーの場合のエラー挙動
  - S3のput_objectでkeyが空の場合の挙動が明確でない
  - 候補：AWS S3 API仕様書 / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：バリデーション関連テストケース（UT-AWS-003〜UT-AWS-019）
  - ソースコードとテストスペックの両方で根拠が確認できる
- **リスク1（中リスク）**：S3Clientの正常系テストケース（UT-AWS-020, UT-AWS-023〜UT-AWS-029）
  - ソースコードで確認可能だが、AWS SDKの挙動に一部依存
- **リスク2（高リスク）**：S3Clientの異常系テストケース（UT-AWS-021, UT-AWS-030）
  - AWS SDKの内部実装に依存するため、実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Aws::Roleのバリデーションルールがビジネス要件と一致しているか確認
- [ ] role_external_idの自動生成ロジック（SecureRandom.hex(20)）がセキュリティ要件を満たすか確認
- [ ] AWS ARN正規表現（/\Aarn:\S+\z/）が十分に厳密か確認（現在は比較的緩い）
- [ ] S3Clientの異常系テストケース（UT-AWS-021, UT-AWS-030）を実環境またはモックで検証
- [ ] http_continue_timeout: nil設定の背景（1xx応答回避）がプロジェクト要件と一致するか確認
