---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 63
  claims_with_evidence: 61
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：badges.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：61 / 63、根拠なし：2
- 優先レビュー（高）
  1. **UT-BDG-047（params dupの検証）**：テスト実装時に確認が必要
  2. **UT-BDG-057（BuildService内部呼び出し）**：モック検証の実装時に確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/badge.rb` - Badgeベースモデル
- E-02: `app/models/badges/group_badge.rb` - GroupBadgeモデル
- E-03: `app/models/badges/project_badge.rb` - ProjectBadgeモデル
- E-04: `app/services/badges/base_service.rb` - BaseServiceクラス
- E-05: `app/services/badges/build_service.rb` - BuildServiceクラス
- E-06: `app/services/badges/create_service.rb` - CreateServiceクラス
- E-07: `app/services/badges/update_service.rb` - UpdateServiceクラス
- E-08: `spec/models/badge_spec.rb` - Badgeモデルのテストスペック
- E-09: `spec/models/badges/project_badge_spec.rb` - ProjectBadgeのテストスペック
- E-10: `spec/models/badges/group_badge_spec.rb` - GroupBadgeのテストスペック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-BDG-001) | rendered_link_urlでプレースホルダーが置換される | E-01 (L41-43), E-08 (L102-107) | ○ |
| C-02 (UT-BDG-002) | projectがnilの場合は元URLが返却される | E-01 (L64-65), E-08 (L109-111) | ○ |
| C-03 (UT-BDG-003) | rendered_image_urlでプレースホルダーが置換されAssetProxy経由になる | E-01 (L45-49), E-08 (L151-155) | ○ |
| C-04 (UT-BDG-004) | AssetProxy有効時にプロキシURLが返却される | E-01 (L46-48), E-08 (L156-170) | ○ |
| C-05 (UT-BDG-005) | project_pathプレースホルダーの置換 | E-01 (L10), E-08 (L102-107) | ○ |
| C-06 (UT-BDG-006) | project_titleプレースホルダーの置換 | E-01 (L11) | ○ |
| C-07 (UT-BDG-007) | project_nameプレースホルダーの置換 | E-01 (L12) | ○ |
| C-08 (UT-BDG-008) | project_idプレースホルダーの置換 | E-01 (L13) | ○ |
| C-09 (UT-BDG-009) | project_namespaceプレースホルダーの置換 | E-01 (L14) | ○ |
| C-10 (UT-BDG-010) | group_nameプレースホルダーの置換 | E-01 (L15) | ○ |
| C-11 (UT-BDG-011) | gitlab_serverプレースホルダーの置換 | E-01 (L16) | ○ |
| C-12 (UT-BDG-012) | gitlab_pages_domainプレースホルダーの置換 | E-01 (L17) | ○ |
| C-13 (UT-BDG-013) | default_branchプレースホルダーの置換 | E-01 (L18) | ○ |
| C-14 (UT-BDG-014) | commit_shaプレースホルダーの置換 | E-01 (L19) | ○ |
| C-15 (UT-BDG-015) | latest_tagプレースホルダーの置換 | E-01 (L20-22) | ○ |
| C-16 (UT-BDG-016) | 空リポジトリ時のプレースホルダー処理 | E-08 (L114-137) | ○ |
| C-17 (UT-BDG-017) | グループなし時のgroup_nameプレースホルダー | E-01 (L15), E-08 (L125) | ○ |
| C-18 (UT-BDG-018) | Procアクションの実行 | E-01 (L75-78) | ○ |
| C-19 (UT-BDG-019) | Symbolアクションの実行 | E-01 (L75-78) | ○ |
| C-20 (UT-BDG-020) | projectがnilの場合nilが返却される | E-01 (L76-77) | ○ |
| C-21 (UT-BDG-021) | シャーディングキー優先制御（group_idがnilになる） | E-01 (L53-61), E-08 (L63-77) | ○ |
| C-22 (UT-BDG-022) | group_idのみ設定時は変更なし | E-01 (L54) | ○ |
| C-23 (UT-BDG-023) | project_idのみ設定時は変更なし | E-01 (L54) | ○ |
| C-24 (UT-BDG-024) | link_url空でバリデーションエラー | E-01 (L38), E-08 (L25-28) | ○ |
| C-25 (UT-BDG-025) | link_url nilでバリデーションエラー | E-01 (L38), E-08 (L31-35) | ○ |
| C-26 (UT-BDG-026) | image_url空でバリデーションエラー | E-01 (L38), E-08 (L25-28) | ○ |
| C-27 (UT-BDG-027) | image_url nilでバリデーションエラー | E-01 (L38), E-08 (L31-35) | ○ |
| C-28 (UT-BDG-028) | httpプロトコルURLが有効 | E-01 (L38), E-08 (L13-16) | ○ |
| C-29 (UT-BDG-029) | httpsプロトコルURLが有効 | E-01 (L38), E-08 (L18-21) | ○ |
| C-30 (UT-BDG-030) | プレースホルダー付きURLが有効 | E-01 (L38), E-08 (L37-41) | ○ |
| C-31 (UT-BDG-031) | javascriptプロトコルURLは無効 | E-01 (L38), E-08 (L43-46) | ○ |
| C-32 (UT-BDG-032) | type空でバリデーションエラー | E-01 (L39) | ○ |
| C-33 (UT-BDG-033) | order_created_at_ascスコープ | E-01 (L30, L32) | ○ |
| C-34 (UT-BDG-034) | with_nameスコープ | E-01 (L34) | ○ |
| C-35 (UT-BDG-035) | GroupBadge groupリレーション | E-02 (L8), E-10 (L7) | ○ |
| C-36 (UT-BDG-036) | GroupBadge group nilでバリデーションエラー | E-02 (L10), E-10 (L12) | ○ |
| C-37 (UT-BDG-037) | GroupBadge group設定で有効 | E-02 (L10) | ○ |
| C-38 (UT-BDG-038) | ProjectBadge projectリレーション | E-03 (L8), E-09 (L9) | ○ |
| C-39 (UT-BDG-039) | ProjectBadge project nilでバリデーションエラー | E-03 (L10), E-09 (L13) | ○ |
| C-40 (UT-BDG-040) | ProjectBadge project設定で有効 | E-03 (L10) | ○ |
| C-41 (UT-BDG-041) | ProjectBadge rendered_link_url引数なしで自身のproject使用 | E-03 (L12-15), E-09 (L33-36) | ○ |
| C-42 (UT-BDG-042) | ProjectBadge rendered_link_url引数ありで指定project使用 | E-03 (L12-15) | ○ |
| C-43 (UT-BDG-043) | ProjectBadge rendered_image_url引数なしで自身のproject使用 | E-03 (L17-20), E-09 (L39-42) | ○ |
| C-44 (UT-BDG-044) | ProjectBadge rendered_image_url引数ありで指定project使用 | E-03 (L17-20) | ○ |
| C-45 (UT-BDG-045) | BaseService initializeでparams初期化 | E-04 (L9-11) | ○ |
| C-46 (UT-BDG-046) | BaseService 空paramsで初期化 | E-04 (L9-11) | ○ |
| C-47 (UT-BDG-047) | BaseService paramsがdupされる | E-04 (L10) | △ |
| C-48 (UT-BDG-048) | BuildService GroupソースでGroupBadge生成 | E-05 (L7-8) | ○ |
| C-49 (UT-BDG-049) | BuildService ProjectソースでProjectBadge生成 | E-05 (L9-10) | ○ |
| C-50 (UT-BDG-050) | BuildService paramsがバッジに設定される | E-05 (L8, L10) | ○ |
| C-51 (UT-BDG-051) | BuildService sourceがバッジに関連付けられる | E-05 (L8, L10) | ○ |
| C-52 (UT-BDG-052) | BuildService 空paramsで動作 | E-05 (L6-11) | ○ |
| C-53 (UT-BDG-053) | CreateService Groupソースでバッジ保存 | E-06 (L6-9) | ○ |
| C-54 (UT-BDG-054) | CreateService Projectソースでバッジ保存 | E-06 (L6-9) | ○ |
| C-55 (UT-BDG-055) | CreateService 無効paramsで保存失敗 | E-06 (L9), E-01 (L38-39) | ○ |
| C-56 (UT-BDG-056) | CreateService 作成バッジが返却される | E-06 (L9) | ○ |
| C-57 (UT-BDG-057) | CreateService BuildServiceが内部で呼び出される | E-06 (L7) | △ |
| C-58 (UT-BDG-058) | UpdateService バッジ更新 | E-07 (L6-11) | ○ |
| C-59 (UT-BDG-059) | UpdateService 更新バッジが返却される | E-07 (L11) | ○ |
| C-60 (UT-BDG-060) | UpdateService 空paramsで更新されない | E-07 (L7-9) | ○ |
| C-61 (UT-BDG-061) | UpdateService nil paramsで更新されない | E-07 (L7) | ○ |
| C-62 (UT-BDG-062) | UpdateService 無効paramsで更新失敗 | E-07 (L8), E-01 (L38-39) | ○ |
| C-63 (UT-BDG-063) | UpdateService 複数属性同時更新 | E-07 (L8) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-47 (UT-BDG-047)**: `params.dup`の動作検証は実装時にテストで確認が必要
  - 候補：モックを使用した検証 / 参照比較テスト
- **C-57 (UT-BDG-057)**: BuildServiceの内部呼び出し検証は実装時にモックテストで確認が必要
  - 候補：expect(Badges::BuildService).to receive(:new) / allow_any_instance_of

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - badgesモジュールは比較的シンプルな構造で、既存テストスペックがモデルのバリデーションとリレーションをカバーしている
- **1: 中リスク** - サービスクラスのテストスペックが存在しないため、サービス層のテストケースは実装時に動作確認が必要
- **0: 低リスク** - プレースホルダー置換機能は既存テストスペックで十分にカバーされている

## 6) レビュアーチェックリスト（最小）
- [ ] Badge.PLACEHOLDERSの全プレースホルダーがテストケースでカバーされているか確認
- [ ] GroupBadgeとProjectBadgeの継承関係が正しくテストされているか確認
- [ ] サービスクラス（Build/Create/Update）の正常系・異常系がバランスよくカバーされているか確認
- [ ] バリデーションエラーケース（XSS対策含む）が十分にカバーされているか確認
- [ ] シャーディングキー優先制御（set_sharding_key_preference）のエッジケースが考慮されているか確認
